/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Mar 1999)
**=======================================================================*/

                                                             /* include files */
#ifndef  _PO_MESH1D_HINTS_ELEMENT_
#define  _PO_MESH1D_HINTS_ELEMENT_


#include <Inventor/elements/SoReplacedElement.h>
#include <MeshViz/nodes/PoMesh1DHints.h>


/**
 * @ingroup MeshVizElements
 */
class MESHVIZ_API PoMesh1DHintsElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(PoMesh1DHintsElement);
  
 public:  
  // Set the current mesh 1D hints attributes
  static void set(SoState *state, SoNode *node, 
                  PoMesh1DHints::GeomInterpretation geomInterpretation);
  
  // Return the current mesh 1D hints attributes from the state
  static PoMesh1DHints::GeomInterpretation get(SoState *state);
  
  // Default values
  static PoMesh1DHints::GeomInterpretation getDefault() 
    { return PoMesh1DHints::AS_IS; }
  
 SoINTERNAL public:
  // Initializes the class
  static void initClass();
	static void exitClass() ;
  
 protected:
  virtual ~PoMesh1DHintsElement();

  /** @copydoc SoElement::init */
  virtual void init(SoState *state);

 private:
  PoMesh1DHints::GeomInterpretation m_geomInterpretation;
};
/*----------------------------------------------------------------------------*/

#endif // _PO_MESH1D_HINTS_ELEMENT_


