/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : J-Michel Godinaud (Feb 1998)
**=======================================================================*/

                                                             /* include files */
#ifndef  _PO_MESH_ELEMENT_
#define  _PO_MESH_ELEMENT_


#include <Inventor/elements/SoReplacedElement.h>


class PbMesh1D;
class PbMesh2D;
class PbMesh3D;
class PbMesh;

/**
 * @ingroup MeshVizElements
 */
class MESHVIZ_API PoMeshElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(PoMeshElement);
  
 public:
  // set the current mesh
  static void set(SoState *state, SoNode *node, const PbMesh1D *mesh);
  static void set(SoState *state, SoNode *node, const PbMesh2D *mesh);
  static void set(SoState *state, SoNode *node, const PbMesh3D *mesh);
  
  // return the current mesh from the state
  static const PbMesh *getMesh(SoState *state);
  static const PbMesh1D *getMesh1D(SoState *state);
  static const PbMesh2D *getMesh2D(SoState *state);
  static const PbMesh3D *getMesh3D(SoState *state);
  
 SoINTERNAL public:
  // Initializes the class
  static void initClass();
	static void exitClass() ;
  
 protected:
  const PbMesh *m_mesh;
  
  virtual ~PoMeshElement();
  
  enum MeshDim {
    MESH_1D,
    MESH_2D,
    MESH_3D
  };
  
  MeshDim m_meshDim;
  virtual void commonInit();

  /** @copydoc SoElement::init */
  virtual void init(SoState *state);
};
/*----------------------------------------------------------------------------*/

#endif // _PO_MESH_ELEMENT_


