/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Jan 1999)
**=======================================================================*/

                                                             /* include files */
#ifndef  _PO_PROFILE_ELEMENT_
#define  _PO_PROFILE_ELEMENT_

#include <Inventor/SbLinear.h>
#include <Inventor/elements/SoReplacedElement.h>

class PoProfile;
class PiCircleArc2;
class PiEllipse2;
class SbBox2f;
class SbVec2f;

/**
 * @ingroup MeshVizElements
 */
class MESHVIZ_API PoProfileElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(PoProfileElement);
  
 public:
  // Set the current profile node
  static void set(SoState *state, SoNode *node, const PoProfile *filter);
  
  // Return the current profile node from the state
  static const PoProfile *get(SoState *state);

  // Return the bounding box of the current profile.
  static SbBox2f getBBox(SoState *state);

  /** Return the current 2D polygon defining the profile.
   * step is only used for circular and elliptic profile.
   * [OIV-WRAPPER-ARG IN,IN,NO_WRAP]
   * [OIV-WRAPPER-RETURN-TYPE ARRAY{number}] 
   */
  static const SbVec2f *getProfile(SoState *state, float step, int &number);

  // Default values
  static PoProfile* getDefault() 
    { return NULL; }

 SoINTERNAL public:
  // Initializes the class
  static void initClass();
	static void exitClass() ;

 protected:
  /** @copydoc SoElement::init */
  virtual void init(SoState *state);

  virtual ~PoProfileElement();

 private:
  PoProfile *m_profile;
  static PiCircleArc2 m_circle;
  static PiEllipse2 m_ellipse;
  static SbVec2f m_profilePoints[360];
};
/*----------------------------------------------------------------------------*/

#endif // _PO_PROFILE_ELEMENT_


