/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_ELLIPTIC_PROFILE_
#define  _PO_ELLIPTIC_PROFILE_

#include <Inventor/fields/SoSFFloat.h>

#include <MeshViz/nodes/PoProfile.h>

/**
 * @DTEXT  Node that defines an elliptic profile.
 * 
 * @ingroup GraphProperty
 * 
 * @DESCRIPTION
 *    This node defines the current elliptic profile for all subsequent 
 *    MeshViz representations inhering from PoChart.
 * 
 * @FILE_FORMAT_DEFAULT
 *    PoEllipticProfile {
 *    @TABLE_FILE_FORMAT
 *       @TR xRadius @TD 2.0
 *       @TR yRadius @TD 1.0
 *    @TABLE_END
 *    }
 * 
 * 
 */
class MESHVIZ_API PoEllipticProfile : public PoProfile {
  
  SO_NODE_HEADER(PoEllipticProfile) ;
  

 public:

  /* Fields */

  /**
   * x radius of the ellipse defining the profile.
   */
  SoSFFloat xRadius ;

  /**
   * y radius of the ellipse defining the profile.
   */
  SoSFFloat yRadius ;

  /**
   * Constructor.
   */
  PoEllipticProfile() ;

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
 protected:
  virtual ~PoEllipticProfile() ;
  
} ;
/*----------------------------------------------------------------------------*/

#endif /* _PO_ELLIPTIC_PROFILE_ */

