/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_PROFILE_COORDINATE2_
#define  _PO_PROFILE_COORDINATE2_

#include <Inventor/fields/SoMFVec2f.h>

#include <MeshViz/nodes/PoProfile.h>

/**
 * @DTEXT  Node that defines a 2D polygon profile.
 * 
 * @ingroup GraphProperty
 * 
 * @DESCRIPTION
 *    This node defines the current 2D polygon profile for all subsequent 
 *    MeshViz representations inhering from PoChart.
 * 
 * 
 * @FILE_FORMAT_DEFAULT
 *    PoProfileCoordinate2 {
 *    @TABLE_FILE_FORMAT
 *       @TR point @TD 0 0
 *    @TABLE_END
 *    }
 * 
 * 
 */
class MESHVIZ_API PoProfileCoordinate2 : public PoProfile {
  
  SO_NODE_HEADER(PoProfileCoordinate2) ;
  

 public:

  /* Fields */

  /**
   * 2D profile coordinate points.
   */
  SoMFVec2f point ;

  /**
   * Constructor.
   */
  PoProfileCoordinate2() ;

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
 protected:
  virtual ~PoProfileCoordinate2() ;
  
} ;
/*----------------------------------------------------------------------------*/

#endif /* _PO_PROFILE_COORDINATE2_ */

