/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_SQUARE_PROFILE_
#define  _PO_SQUARE_PROFILE_

#include <Inventor/fields/SoSFFloat.h>

#include <MeshViz/nodes/PoProfile.h>

/**
 * @DTEXT  Node that defines a square profile.
 * 
 * @ingroup GraphProperty
 * 
 * @DESCRIPTION
 *    This node defines the current square profile for all subsequent 
 *    MeshViz representations inhering from PoChart.
 * 
 * @FILE_FORMAT_DEFAULT
 *    PoSquareProfile {
 *    @TABLE_FILE_FORMAT
 *       @TR width @TD 1.0
 *       @TR height @TD 1.0
 *    @TABLE_END
 *    }
 * 
 * 
 */
class MESHVIZ_API PoSquareProfile : public PoProfile {
  
  SO_NODE_HEADER(PoSquareProfile) ;
  

 public:

  /* Fields */

  SoSFFloat width ;



  SoSFFloat height ;

  /**
   * Constructor.
   */
  PoSquareProfile() ;

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
 protected:
  virtual ~PoSquareProfile() ;
  
} ;
/*----------------------------------------------------------------------------*/

#endif /* _PO_SQUARE_PROFILE_ */

