/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#pragma once

#include <Inventor/STL/iostream>
#include <Inventor/STL/sstream>
#include <Inventor/STL/string>

 /**
 * @DTEXT Exception handler for MeshViz XLM.
 * 
 * @ingroup MeshVizXLM
 * 
 * @DESCRIPTION This class is used when throwing an exception when an algorithm is cancelled.
 *
 */
class MiCancellationException : public std::exception
{
public:
  /**
  * Constructor
  */
  MiCancellationException(std::string algorithmName)
  {
    std::stringstream algoStream;
    algoStream << algorithmName << " has been cancelled.";
    m_algorithmCancelled = algoStream.str();
  }
  
  /**
  * Returns the c-string containing the name of the algorithm that has been cancelled.
  */
  virtual const char* what() const throw ()
  {
    return m_algorithmCancelled.c_str();
  }

  ~MiCancellationException() throw ()
  {
  }

protected: 
  std::string m_algorithmCancelled;
 
};



