/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIMESHVIZ_H
#define _MIMESHVIZ_H

#include <MeshVizXLM/MxMeshVizXLM.h>

/**
 * @DTEXT Class to initialize the MeshViz Mesh Extraction module.
 * 
 * @ingroup MeshVizXLM
 * 
 * @DESCRIPTION
 *   This class is used to initialize and finish the Mesh Extraction module.
 *   The init() method must be called before using any other Mesh Extraction classes.
 *
 *   This class is provided for stand-alone use of Mesh Extraction (separate
 *   from Open Inventor). If using MeshViz Data Mapping, it is not necessary to
 *   explicitly initalize Mesh Extraction because this is done automatically
 *   by the MoMeshViz class.
 *
 * @SEE_ALSO
 *    MoMeshViz
 * 
 * 
 */ 

class MESHVIZXLM_EXTR_API MiMeshViz {

 public:

  /**
   * Initializes all Mesh Extraction classes.
   * This function must be called before any other Mesh Extraction class may be constructed or used. 
   * @param numThreads is the number of threads allocated to the extractors 
   *                   with multi-threading enabled (see for instance MiSkinExtractUnstructured::getNewInstance(mesh,parallel)).
   *                   If numThreads is not 1, multiple threads can be used during every extraction algorithm.
   *                   In that case, all the methods of the geometry and topology interfaces must be thread-safe as they can be called concurrently.
   *                   For instance, for unstructured mesh, pay particular attention to the implementation of the methods getCoord,
   *                   getCell and the methods that implement the MiCell interface.
   *                   Default value is 0 which allocates the maximum number of threads available.
   *                   Negative values allocate the maximum number of threads available decreased by the given number.
   *                   For instance, value -2 allocates the maximum number of threads available minus 2. 
   */
  static void init(int numThreads = 0);

	/**
   * Finishes all classes of MeshViz extraction.
   * This function should be called after all Mesh Extraction objects
   * have been destroyed, to ensure that any static memory allocations
   * are freed.
   */
	static void finish();

  /**
  * Returns a character string identifying the name of the extension.
  */
  static const char* getProductName();

#if SoDEPRECATED_BEGIN(2023200)
  /**
   * Returns a character string identifying the version of the extension.
   */
  SoDEPRECATED_METHOD(2023.2, "This method should no longer be used. Use SoLicensesInfo::getVersion() method instead.")
  static const char *getVersion();
#endif /** @DEPRECATED_END */

  /**
  * Returns true if MeshViz XLM is initialized
  */
  static bool isInitialized();

 private:

  // Init/finish ref counter status
  static int s_initRefCount;

} ;



#endif


