/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MICELLEXTRACTHEXAHEDRONIJK_H
#define  _MICELLEXTRACTHEXAHEDRONIJK_H

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

#include <MeshVizXLM/extractors/MiCellExtractIjk.h>
#include <MeshVizXLM/mesh/MiVolumeMeshHexahedronIjk.h>
#include <MeshVizXLM/tessellator/MiTessellator.h>


/**
 * @DTEXT Cell extractor for hexahedron IJK meshes
 * 
 * @ingroup MeshVizXLM_Extract_Cell
 * 
 * @DESCRIPTION Extracts a list of cells from the input hexahedron IJK mesh and builds a surface mesh representing the extracted cells.
 * 
 */

class MESHVIZXLM_EXTR_API MiCellExtractHexahedronIjk : virtual public MiCellExtractIjk
{
public:
    
  virtual ~MiCellExtractHexahedronIjk() {}

  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */
  static MiCellExtractHexahedronIjk* getNewInstance(const MiVolumeMeshHexahedronIjk& mesh, bool parallel = true, MiTessellator* tessellator=NULL);

/**
 * Extracts a PER_NODE scalar set from the original mesh. The scalars are mapped onto the
 * current extracted mesh.
 * 
 * @note The argument i of the method MiScalardSetI::get(i) refers
 * to the i-th node of the mesh. Thus the binding of the inputSet
 * must be PER_NODE. An exception is thrown otherwise.
 * 
 * @param inputSet the input scalar set defined on the volume mesh.
 * @return the output scalar set defined on the extracted mesh.
 */
 virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) = 0;

 /**
 * Extracts a PER_CELL scalar set from the original mesh. The scalars are mapped onto the
 * current extracted mesh.
 *
 * @note The argument i,j,k of the method MiScalardSetIjk::get(i,j,k) refers
 * to the cell (i,j,k). Thus the binding of the inputSet
 * must be PER_CELL. An exception is thrown otherwise.
 * 
 * @param inputSet the input scalar set defined on the volume mesh.
 * @return the output scalar set defined on the extracted mesh.
 */
 virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetIjk& inputSet) = 0;

 /**
 * Extracts a PER_NODE vector set from the original mesh. The vectors are mapped onto the
 * current extracted mesh.
 *
 * @note The argument i of the method MiVec3dSetI::get(i) refers
 * to the i-th node of the mesh. Thus the binding of the inputSet
 * must be PER_NODE. An exception is thrown otherwise.
 * 
 * @param inputSet the input vector set defined on the volume mesh.
 * @return the output vector set defined on the extracted mesh.
 */
 virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

 /**
 * Extracts a PER_CELL vector set from the original mesh. The vectors are mapped onto the
 * current extracted mesh.
 *
 * @note The argument i,j,k of the method MiVec3dSetIjk::get(i,j,k) refers
 * to the cell (i,j,k). Thus the binding of the inputSet
 * must be PER_CELL. An exception is thrown otherwise.
 * 
 * @param inputSet the input vector set defined on the volume mesh.
 * @return the output vector set defined on the extracted mesh.
 */
 virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetIjk& inputSet) = 0;

 /**
 * Extracts a PER_NODE string set from the original mesh. The strings are mapped onto the
 * current extracted mesh.
 *
 * @note The argument i of the method MiStringSetI::get(i) refers
 * to the i-th node of the mesh. Thus the binding of the inputSet
 * must be PER_NODE. An exception is thrown otherwise.
 *
 * @param inputSet the input string set defined on the volume mesh.
 * @return the output string set defined on the extracted mesh.
 */
 virtual const MeXStringSetI& extractStringSet(const MiStringSetI& inputSet) = 0;

 /**
 * Extracts a PER_CELL string set from the original mesh. The strings are mapped onto the
 * current extracted mesh.
 *
 * @note The argument i,j,k of the method MiStringSetIjk::get(i,j,k) refers
 * to the cell (i,j,k). Thus the binding of the inputSet
 * must be PER_CELL. An exception is thrown otherwise.
 *
 * @param inputSet the input string set defined on the volume mesh.
 * @return the output string set defined on the extracted mesh.
 */
 virtual const MeXStringSetI& extractStringSet(const MiStringSetIjk& inputSet) = 0;

};

#endif /* _MICELLEXTRACTHEXAHEDRONIJK_H */


