/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MICELLEXTRACTIJ_H
#define  _MICELLEXTRACTIJ_H

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/mesh/data/MiDataSetIj.h>
#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

#include <MeshVizXLM/mesh/MiSurfaceMeshRegular.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshRectilinear.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshCurvilinear.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>
#include <MeshVizXLM/tessellator/MiTessellator.h>

#include <Inventor/STL/vector>

class MiCellFilterIj;

/**
 * @DTEXT Cell extractor for structured surface meshes
 * 
 * @ingroup MeshVizXLM_Extract_Cell
 * 
 * @DESCRIPTION Extracts a list of cells from the input structured mesh and builds a surface mesh representing the extracted cells.
 * 
 * 
 * 
 */

class MESHVIZXLM_EXTR_API MiCellExtractIj : virtual public MiBaseExtractor
{
public:
    
  virtual ~MiCellExtractIj() {}

  //@{
  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */ 
  static MiCellExtractIj* getNewInstance(const MiSurfaceMeshRegular& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiCellExtractIj* getNewInstance(const MiSurfaceMeshRectilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiCellExtractIj* getNewInstance(const MiSurfaceMeshCurvilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  //@}

  /**
  * A pair of indices used to define the cells to be extracted
  */ 
  class couple 
  {
  public:
    couple():i(0),j(0) {} /**< constructor */
    couple(size_t x, size_t y):i(x),j(y) {} /**< constructor */
    couple(size_t v):i(v),j(v) {} /**< constructor */
    size_t i; /**< I index*/
    size_t j; /**< J index */
    /** == operator */
    friend bool operator ==(const couple &t1, const couple &t2) 
    { return (t1.i==t2.i && t1.j==t2.j);}
    /** < operator */
    friend bool operator <(const couple &t1, const couple &t2) 
    { return (t1.i<t2.i || (t1.i==t2.i && t1.j<t2.j)); }
  };

  /**
  * Creates an unstructured surface mesh from the cells faces corresponding to the
  * given indices in the original volume mesh. Cells are scaled depending on the given
  * factor.@n 
  * Shrinking: factor < 1@n 
  * Expanding: factor > 1
  */
  virtual const MeXSurfaceMeshUnstructured&
  extractCell(const std::vector<couple>& cellIndexes, double factor, const MiCellFilterIj* cellFilter=NULL) = 0;

  /**
  * Creates an unstructured surface mesh from the faces of the cells corresponding to the
  * given indices in the original volume mesh. Cells are resized according to the given
  * factor.@n 
  * Shrinking: factor < 1@n 
  * Expanding: factor > 1
  */
  virtual const MeXSurfaceMeshUnstructured&
  extractCell(double factor, const MiCellFilterIj* cellFilter=NULL) = 0;
 
  /**
  * Extracts a scalar set from the surface mesh. The scalars are mapped onto the 
  * current extracted mesh. 
  *
  * @param inputSet The input scalar set defined on the surface mesh.
  * @return The output scalar set defined on the extracted mesh.
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetIj& inputSet) = 0;

  /**
  * Extracts a vector set from the surface mesh. The vectors are mapped onto the 
  * current extracted mesh. 
  *
  * @param inputSet The input vector set defined on the surface mesh.
  * @return The output scalar set defined on the extracted mesh.
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetIj& inputSet) = 0;

  /**
  * Extracts a string set from the surface mesh. The strings are mapped onto the
  * current extracted mesh.
  *
  * @param inputSet The input string set defined on the surface mesh.
  * @return The output string set defined on the extracted mesh.
  */
  virtual const MeXStringSetI& extractStringSet(const MiStringSetIj& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;

};

#endif /* _MICELLEXTRACTIJ_H */


