/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MICELLEXTRACTUNSTRUCTURED_H
#define  _MICELLEXTRACTUNSTRUCTURED_H

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshUnstructured.h>
#include <MeshVizXLM/tessellator/MiTessellator.h>

#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>

#include <Inventor/STL/vector>

class MiCellFilterI;
class MeXLineMeshUnstructured;
class MeXPointMeshCurvilinear;

/**
 * @DTEXT Cell extractor for unstructured meshes
 * 
 * @ingroup MeshVizXLM_Extract_Cell
 * 
 * @DESCRIPTION Extracts a list of cells from the input unstructured mesh and builds a surface mesh or a line mesh 
 *              representing the extracted cells.
 * 
 * 
 * 
 */

class MESHVIZXLM_EXTR_API MiCellExtractUnstructured : virtual public MiBaseExtractor
{
public:
    
  virtual ~MiCellExtractUnstructured() {}

  //@{
  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */ 
  static MiCellExtractUnstructured* getNewInstance(const MiVolumeMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiCellExtractUnstructured* getNewInstance(const MiSurfaceMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  //@}

   //@{
  /**
  * Create unstructured surface and line meshes from the faces of the cells corresponding to the
  * given indices in the original volume mesh. Cells are scaled according to the given
  * factor. @n
  * Shrinking: factor < 1 @n
  * Expanding: factor > 1
  */
  virtual const MeXSurfaceMeshUnstructured&
  extractCell(const std::vector<size_t>& cellIndex, double factor, const MiCellFilterI* cellFilter=NULL) = 0;
  virtual const MeXLineMeshUnstructured&
  extractLineCell(const std::vector<size_t>& cellIndex, double factor, const MiCellFilterI* cellFilter=NULL) = 0;
  virtual const MeXPointMeshCurvilinear&
  extractPoints(const std::vector<size_t>& cellIndex, double factor, const MiCellFilterI* cellFilter=NULL) = 0;
  //@}

  //@{
  /**
  * @copydoc MiCellExtractIjk::extractCell(double factor, const MiCellFilterIjk* cellFilter)
  */
  virtual const MeXSurfaceMeshUnstructured&
  extractCell(double factor, const MiCellFilterI* cellFilter=NULL) = 0;
  virtual const MeXLineMeshUnstructured&
  extractLineCell(double factor, const MiCellFilterI* cellFilter=NULL) = 0;
  virtual const MeXPointMeshCurvilinear&
  extractPoints(double factor, const MiCellFilterI* cellFilter=NULL) = 0;
  //@}
 
  /**
  * @copydoc MiCellExtractIjk::extractScalarSet(const MiScalardSetIjk& inputSet)
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::extractVec3Set(const MiVec3dSetIjk& inputSet)
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::extractStringSet(const MiStringSetIjk& inputSet)
  */
  virtual const MeXStringSetI& extractStringSet(const MiStringSetI& inputSet) = 0;

  //@{
  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;
  virtual const MeXLineMeshUnstructured&    getLineExtract() const = 0;
  virtual const MeXPointMeshCurvilinear&    getPointExtract() const = 0;
  //@}
};

#endif /* _MICELLEXTRACT_H */


