/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (October 2009)
**=======================================================================*/
#ifndef  _MiClipLineExtractIj_h
#define  _MiClipLineExtractIj_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/data/MiDataSetIj.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXLineMeshUnstructured.h>

class MiCellFilterIj;
class MiSurfaceMeshRegular;
class MiSurfaceMeshCurvilinear;
class MiSurfaceMeshRectilinear;
class MiTessellator;

/**
 * @DTEXT Clip line extractor for structured surface meshes
 * 
 * @ingroup MeshVizXLM_Extract_Clip
 * 
 * @DESCRIPTION
 * A clip line is the intersection of a plane or a list of planes with the surface mesh. The extracted line
 * is an unstructured line.
 * 
 */
class MESHVIZXLM_EXTR_API MiClipLineExtractIj : virtual public MiBaseExtractor
{
public:
  virtual ~MiClipLineExtractIj() {}

  //@{
  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */ 
  static MiClipLineExtractIj* getNewInstance(const MiSurfaceMeshRegular& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiClipLineExtractIj* getNewInstance(const MiSurfaceMeshCurvilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiClipLineExtractIj* getNewInstance(const MiSurfaceMeshRectilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  //@}

  /**
  * Computes a 3D polyline as the result of the intersection of the surface mesh and the given plane.
  *
  * @param normal Vector normal to the plane
  * @param distance Position of the plane relatively to the origin along the normal
  * @param cellFilter The cell filter object.
  * @return An unstructured line mesh representing the clip line
  */
  virtual const MeXLineMeshUnstructured& extractLine(const MbVec3<double>& normal, double distance, const MiCellFilterIj* cellFilter=NULL) = 0;

  /**
   * Computes a 3D polyline as the result of the intersection of several planes and the surface mesh.
   * The arbitrary planes (or fences) are defined by a polyline and a direction.
   * The clip line extracted is returned as an unstructured line mesh.
   *
   * @param direction vector defining the direction of the fences
   * @param polyline set of points defining the position of the fences
   * @param cellFilter the cell filter object.
   * @return An unstructured line mesh representing the clip line
   *
   * @M_SINCE 2023.1
   */
  virtual const MeXLineMeshUnstructured& extractLine( const MbVec3d& direction, const std::vector<MbVec3d>& polyline, const MiCellFilterIj* cellFilter = NULL ) = 0;

  /**
  * Extracts a scalar set from the surface mesh. The scalars are mapped onto the 
  * current extracted clip sline. 
  *
  * @param inputSet the input scalar set defined on the surface mesh
  * @return the output scalar set defined on the resulting line mesh
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetIj& inputSet) = 0;

  /**
  * Extracts a vector set from the surface mesh. The vectors are mapped onto the 
  * current extracted clip line.
  *
  * @param inputSet the input vec3 set defined on the surface mesh
  * @return the output scalar set defined on the resulting line mesh
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetIj& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXLineMeshUnstructured& getExtract() const = 0;

};

#endif 


