/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (October 2009)
**=======================================================================*/
#ifndef  _MiClipLineExtractUnstructured_h
#define  _MiClipLineExtractUnstructured_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXLineMeshUnstructured.h>

class MiCellFilterI;
class MiTessellator;

/**
 * @DTEXT Clip line extractor for unstructured surface meshes
 * 
 * @ingroup MeshVizXLM_Extract_Clip
 * 
 * @DESCRIPTION
 * A clip line is the intersection of a plane or a list of planes with the surface mesh. The extracted line
 * is an unstructured line.
 * 
 */
class MESHVIZXLM_EXTR_API MiClipLineExtractUnstructured : virtual public MiBaseExtractor
{
public:
  virtual ~MiClipLineExtractUnstructured() {}

  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */ 
  static MiClipLineExtractUnstructured* getNewInstance(const MiSurfaceMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator=NULL);

  /**
  * @copydoc MiClipLineExtractIj::extractLine(const MbVec3<double>& normal, double distance, const MiCellFilterIj* cellFilter)
  */
  virtual const MeXLineMeshUnstructured& extractLine(const MbVec3<double>& normal, double distance, const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * @copydoc MiClipLineExtractIj::extractLine(const MbVec3d& direction, const std::vector<MbVec3d>& polyline, const MiCellFilterIj* cellFilter)
  */
  virtual const MeXLineMeshUnstructured& extractLine( const MbVec3d& direction, const std::vector<MbVec3d>& polyline, const MiCellFilterI* cellFilter = NULL ) = 0;

  /**
  * @copydoc MiClipLineExtractIj::extractScalarSet()
  */ 
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) = 0;

  /**
  * @copydoc MiClipLineExtractIj::extractVec3Set()
  */ 
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXLineMeshUnstructured& getExtract() const = 0;

};

#endif 


