/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiCylinderSliceExtractUnstructured_h
#define  _MiCylinderSliceExtractUnstructured_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>

class MiCellFilterI;
class MiTessellator;

/**
 * @DTEXT Cylinder slice extractor for unstructured volume meshes
 * 
 * @ingroup MeshVizXLM_Extract_Slice
 * 
 * @DESCRIPTION 
 * A cylinder slice is a surface mesh defined by the intersection of a cylinder of 
 * infinite length with the input mesh. The cylinder is defined by a point on its 
 * central axis, a vector representing the central axis direction and the radius.
 *
 * Additional data sets can be mapped onto this extracted surface by calling the 
 * extractScalarSet() or extractVec3Set() methods.
 *
 * The following sample code shows how to extract a cylinder slice from a mesh: 
 * \if_cpp
 * \code
 *   MiCylinderSliceExtractUnstructured* cylinderSliceExtract =
 *     MiCylinderSliceExtractUnstructured::getNewInstance(mesh);
 *   const MeXSurfaceMeshUnstructured& cylinderSlice =
 *     cylinderSliceExtract->extractSlice(center, radius, direction, NULL);
 * \endcode
 * \endif
 * \if_dotnet
 * \endif
 * \if_java
 * \endif
 *
 */
class MESHVIZXLM_EXTR_API MiCylinderSliceExtractUnstructured : virtual public MiBaseExtractor
{
public:
  virtual ~MiCylinderSliceExtractUnstructured() {}

  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */ 
  static MiCylinderSliceExtractUnstructured* getNewInstance(const MiVolumeMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator=NULL);

  /**
  * @copydoc MiCylinderSliceExtractIjk::extractSlice()
  */ 
  virtual const MeXSurfaceMeshUnstructured& extractSlice(const MbVec3<double>& center, double radius, const MbVec3<double>& direction, const MiCellFilterI* cellFilter=NULL) = 0;
  
  /**
  * @copydoc MiCellExtractIjk::extractScalarSet()
  */ 
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::extractVec3Set()
  */ 
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;

};

#endif 


