/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiCylinderSliceExtractUnstructredIjk_h
#define  _MiCylinderSliceExtractUnstructredIjk_h

#include <MeshVizXLM/extractors/MiCylinderSliceExtractHexahedronIjk.h>

/**
 * @DTEXT Cylinder slice extractor for hexahedron IJK volume meshes
 * 
 * @ingroup MeshVizXLM_Extract_Slice
 * 
 * @DESCRIPTION 
 * A cylinder slice is a surface mesh defined by the intersection of a cylinder of 
 * infinite length with the input mesh. The cylinder is defined by a point on its 
 * central axis, a vector representing the central axis direction and the radius.
 *
 * Additional data sets can be mapped onto this extracted surface by calling the 
 * extractScalarSet() or extractVec3Set() methods.
 *
 * The following sample code shows how to extract a cylinder slice from a mesh: 
 * \if_cpp
 * \code
 *   MiCylinderSliceExtractHexahedronIjk* cylinderSliceExtract =
 *     MiCylinderSliceExtractHexahedronIjk::getNewInstance(mesh);
 *   const MeXSurfaceMeshUnstructured& cylinderSlice =
 *     cylinderSliceExtract->extractSlice(center, radius, direction, NULL);
 * \endcode
 * \endif
 * \if_dotnet
 * \endif
 * \if_java
 * \endif
 * 
 */

typedef SoDEPRECATED_TYPEDEF( 10000, "Use MiCylinderSliceExtractHexahedronIjk interface instead." ) MiCylinderSliceExtractHexahedronIjk MiCylinderSliceExtractUnstructuredIjk;

#endif 


