/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiFenceSliceExtractUnstructuredIjk_h
#define  _MiFenceSliceExtractUnstructuredIjk_h

#include <MeshVizXLM/extractors/MiFenceSliceExtractHexahedronIjk.h>

/**
 * @DTEXT Fence slice extractor for hexahedron Ijk meshes
 * 
 * @ingroup MeshVizXLM_Extract_Slice
 * 
 * @DESCRIPTION
 *  A fence slice is an unstructured surface mesh defined by the intersection of several arbitrary planes (the fences)
 *  with a volume mesh. These fences are defined by a polyline and a direction. Each segment of the polyline is
 *  extruded along the direction to form a clipped plane slice. Thus, each fence goes through a segment of the polyline.
 *  Each plane slice is clipped by the extrusion of the 2 endpoints of each segment in the direction.
 * The extracted fence slice is an unstructured surface.
 * 
 * @SEE_ALSO
 * MoMeshFenceSlice, MiFenceSliceExtractIjk, MiFenceSliceExtractUnstructured
 * 
 */

typedef SoDEPRECATED_TYPEDEF(10000,"Use MiFenceSliceExtractHexahedronIjk interface instead.") MiFenceSliceExtractHexahedronIjk MiFenceSliceExtractUnstructuredIjk;


#endif 


