/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiGridPlaneSliceExtractHexahedronIjk_H
#define  _MiGridPlaneSliceExtractHexahedronIjk_H

#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetIj.h>
#include <MeshVizXLM/extractors/MiGridPlaneSliceExtractIjk.h>

#include <MeshVizXLM/mesh/MiVolumeMeshHexahedronIjk.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshCurvilinear.h>

#include <Inventor/STL/vector>

class MiCellFilterIjk;
class MiTessellator;

/**
 * @DTEXT Grid plane slice extractor on hexahedron IJK volume meshes
 * 
 * @ingroup MeshVizXLM_Extract_Slice
 * 
 * @DESCRIPTION This extractor is similar to the plane slice extractor except that it creates a structured mesh and probes the 
 * input volume to compute the values at the surface nodes and cells (See MiPointProbeUnstructured for settings). 
 * The grid created by this extractor is computed so that it encloses completely the cross section of the input volume mesh marking as dead the
 * cells outside the volume.
 * 
 */

class MESHVIZXLM_EXTR_API MiGridPlaneSliceExtractHexahedronIjk : virtual public MiGridPlaneSliceExtractIjk
{
public:
    
  virtual ~MiGridPlaneSliceExtractHexahedronIjk() {}

  /**
  * @copydoc MiInterpolatedLogicalSliceExtract::getNewInstance()
  */ 
  static MiGridPlaneSliceExtractHexahedronIjk* getNewInstance(const MiVolumeMeshHexahedronIjk& mesh, bool parallel = true, MiTessellator* tessellator = NULL);
 
  /**
  * @copydoc MiGridPlaneSliceExtractUnstructured::extractScalarSet()
  */ 
  virtual const MeXScalardSetIj& extractScalarSet(const MiScalardSetI& inputSet) = 0;

  /**
  * @copydoc MiGridPlaneSliceExtractUnstructured::extractScalarSet()
  */ 
  virtual const MeXScalardSetIj& extractScalarSet(const MiScalardSetIjk& inputSet) = 0;

  /**
  * @copydoc MiGridPlaneSliceExtractUnstructured::extractVec3Set()
  */ 
  virtual const MeXVec3dSetIj& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * @copydoc MiGridPlaneSliceExtractUnstructured::extractVec3Set()
  */ 
  virtual const MeXVec3dSetIj& extractVec3Set(const MiVec3dSetIjk& inputSet) = 0;

};

#endif /* _MiGridPlaneSliceExtractHexahedronIjk_H */


