/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiGridPlaneSliceExtractIjk_H
#define  _MiGridPlaneSliceExtractIjk_H

#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetIj.h>
#include <MeshVizXLM/extractors/MiBaseExtractor.h>

#include <MeshVizXLM/mesh/MiVolumeMeshRegular.h>
#include <MeshVizXLM/mesh/MiVolumeMeshRectilinear.h>
#include <MeshVizXLM/mesh/MiVolumeMeshCurvilinear.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshCurvilinear.h>

#include <Inventor/STL/vector>

class MiCellFilterIjk;
class MiTessellator;

/**
 * @DTEXT Grid plane slice extractor on structured volume meshes
 * 
 * @ingroup MeshVizXLM_Extract_Slice
 * 
 * @DESCRIPTION This extractor is similar to the plane slice extractor except that it creates a structured mesh and probes the 
 * input volume to compute the values at the surface nodes and cells (See MiPointProbeUnstructured for settings on curvilinear mesh). 
 * The grid created by this extractor is computed so that it encloses completely the cross section of the input volume mesh marking as dead the
 * cells outside the volume.
 * 
 */

class MESHVIZXLM_EXTR_API MiGridPlaneSliceExtractIjk : virtual public MiBaseExtractor
{
public:
    
  virtual ~MiGridPlaneSliceExtractIjk() {}

  //@{
  /**
  * @copydoc MiInterpolatedLogicalSliceExtract::getNewInstance()
  */ 
  static MiGridPlaneSliceExtractIjk* getNewInstance(const MiVolumeMeshRegular& mesh, bool parallel = true, MiTessellator* tessellator = NULL);
  static MiGridPlaneSliceExtractIjk* getNewInstance(const MiVolumeMeshRectilinear& mesh, bool parallel = true, MiTessellator* tessellator = NULL);
  static MiGridPlaneSliceExtractIjk* getNewInstance(const MiVolumeMeshCurvilinear& mesh, bool parallel = true, MiTessellator* tessellator = NULL);
  //@}

  /**
  * Builds the topology and geometry of a curvilinear surface mesh defined by the given plane normal and distance to origin.
  * This grid is computed so that it encloses completely the cross section of the input volume mesh. 
  * @param normal Vector normal to the grid plane slice
  * @param distance Position of the plane relatively to the origin along the normal
  * @param step Distance between two consecutive nodes in both directions of the plane
  * @param cellFilter The cell filter object. 
  * @return A curvilinear surface mesh representing the grid plane slice
  */
  virtual const MeXSurfaceMeshCurvilinear&
  extractGrid(const MbVec3<double>& normal, double distance, double step, const MiCellFilterIjk* cellFilter=NULL) = 0;
 
  /**
  * @copydoc MiCellExtractIjk::extractScalarSet(const MiScalardSetIjk& inputSet)
  */
  virtual const MeXScalardSetIj& extractScalarSet(const MiScalardSetIjk& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::extractVec3Set(const MiVec3dSetIjk& inputSet)
  */
  virtual const MeXVec3dSetIj& extractVec3Set(const MiVec3dSetIjk& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXSurfaceMeshCurvilinear& getExtract() const = 0;

};

#endif /* _MiGridPlaneSliceExtractIjk_H */


