/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MIISOLINEEXTRACT_H
#define  _MIISOLINEEXTRACT_H

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXLineMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

#include <Inventor/STL/vector>

class MiSurfaceMeshUnstructured;
class MiCellFilterI;
class MiLineMeshUnstructured;

/**
 * @DTEXT Isoline extractor for unstructured surface meshes.
 * 
 * @ingroup MeshVizXLM_Extract_Isoline
 * 
 * @DESCRIPTION Builds a list of lines containing the extracted isolines for the given data set at the given values.
 * 
 * 
 */
class MESHVIZXLM_EXTR_API MiIsolineExtractUnstructured : virtual public MiBaseExtractor
{
public:
  virtual ~MiIsolineExtractUnstructured() {}

  /**
  * Factory method returning a new instance of a class implementing this abstract class.
  * @param mesh The input mesh 
  * @param parallel When true, tries to create an extract module using a parallel algorithm to speed up the extraction. 
  * @note Only some of the extraction algorithms have a parallel implementation.
  */ 
  static MiIsolineExtractUnstructured* getNewInstance(const MiSurfaceMeshUnstructured& mesh, bool parallel = true); 

  /**
  * @copydoc MiIsolineExtractIj::extractIsovalue()
  */  
  virtual const std::vector<const MeXLineMeshUnstructured*>&
  extractIsovalue(std::vector<double>& isovalueList, const MiScalardSetI& dataSet, 
                       const MiCellFilterI* cellFilter=NULL) = 0;
  
  /**
  * @copydoc MiIsolineExtractIj::extractScalarSet()
  */  
  virtual const std::vector< const MeXScalardSetI* >& extractScalarSet(const MiScalardSetI& inputSet) =0;

 /**
  * @copydoc MiIsolineExtractIj::extractVec3Set()
  */  
  virtual const std::vector< const MeXVec3dSetI* >& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

 /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
 virtual const std::vector<const MeXLineMeshUnstructured*>& getExtract() const = 0;

};

#endif /* _MIISOSURFEXTRACT_H */


