/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiIsosurfExtractHexahedronIjk_H
#define  _MiIsosurfExtractHexahedronIjk_H

#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>
#include <MeshVizXLM/extractors/MiIsosurfExtractIjk.h>

class MiCellFilterIjk;
class MiVolumeMeshHexahedronIjk;
class MiTessellator;

/**
 * @DTEXT Isosurface extractor for hexahedron IJK meshes
 * 
 * @ingroup MeshVizXLM_Extract_Isosurf
 * 
 * @DESCRIPTION Builds the isosurface of the given isovalue in the given dataset.
 * 
 * 
 */
class MESHVIZXLM_EXTR_API MiIsosurfExtractHexahedronIjk : virtual public MiIsosurfExtractIjk
{
public:
  virtual ~MiIsosurfExtractHexahedronIjk() {}
  
  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */
  static MiIsosurfExtractHexahedronIjk* getNewInstance(const MiVolumeMeshHexahedronIjk& mesh, bool parallel = true, MiTessellator* tessellator=NULL);

  /**
  * Builds the isosurface of the given isovalue in the given PER_NODE dataset as a surface mesh. 
  * @note MiScalardSetI dataset must always be bound PER_NODE to the mesh, otherwise use MiScalarSetIjk.
  * @param isovalue Value for which an isosurface must be computed
  * @param dataSet The input PER_NODE data set used to compute the isovalue from
  * @param cellFilter The cell filter
  * @return The extracted isosurface
  */
  virtual const MeXSurfaceMeshUnstructured& extractIsovalue(double isovalue, const MiScalardSetI& dataSet, const MiCellFilterIjk* cellFilter=NULL) = 0;

  /**
  * Builds the isosurface of the given isovalue in the given PER_CELL dataset as a surface mesh. 
  * @note MiScalardSetIjk dataset must always be bound PER_CELL to the mesh, otherwise use MiScalarSetI.
  * @note In this case of a dataset bound PER_CELL, it will be converted into 
  * a new internal dataset bound PER_NODE and cached in the extractor.
  * @param isovalue Value for which an isosurface must be computed
  * @param dataSet The input data set used to compute the isovalue from
  * @param cellFilter The cell filter
  * @return The extracted isosurface
  */
  virtual const MeXSurfaceMeshUnstructured& extractIsovalue(double isovalue, const MiScalardSetIjk& dataSet, const MiCellFilterIjk* cellFilter=NULL) = 0;

 /**
 * Computes a PER_NODE scalar set on the extracted isosurface. 
 * Note : The argument i of the method MiScalardSetI::get(i) refers
 * to the i-th node of the mesh. Thus the binding of the inputSet
 * must be PER_NODE. An exception is thrown otherwise.
 * 
 * @param inputSet the input scalar set defined on the volume mesh
 * @return the output scalar set defined on the resulting isosurface mesh
 */
 virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) = 0;

 /**
 * Computes a PER_CELL scalar set on the extracted isosurface. 
 * Note : The argument i,j,k of the method MiScalardSetIjk::get(i,j,k) refers
 * to the cell (i,j,k). Thus the binding of the inputSet
 * must be PER_CELL. An exception is thrown otherwise.
 * 
 * @param inputSet the input scalar set defined on the volume mesh
 * @return the output scalar set defined on the resulting isosurface mesh
 */
 virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetIjk& inputSet) = 0;

 /**
 * Computes a vector set on the extracted isosurface.
 * Note : The argument i of the method MiVec3dSetI::get(i) refers
 * to the i-th node of the mesh. Thus the binding of the inputSet
 * must be PER_NODE. An exception is thrown otherwise.
 * 
 * @param inputSet the input vector set defined on the volume mesh
 * @return the output scalar set defined on the resulting isosurface mesh
 */
 virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

 /**
 * Computes a vector set on the extracted isosurface.
 * Note : The argument i,j,k of the method MiVec3dSetIjk::get(i,j,k) refers
 * to the cell (i,j,k). Thus the binding of the inputSet
 * must be PER_CELL. An exception is thrown otherwise.
 * 
 * @param inputSet the input vector set defined on the volume mesh
 * @return the output scalar set defined on the resulting isosurface mesh
 */
 virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetIjk& inputSet) = 0;

};


#endif 


