/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MIISOSURFEXTRACTUNSTRUCTURED_H
#define  _MIISOSURFEXTRACTUNSTRUCTURED_H

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>

class MiCellFilterI;
class MiVolumeMeshUnstructured;
class MiTessellator;

class MeXLineMeshUnstructured;

/**
* @DTEXT Isosurface extractor for unstructured meshes
* 
* @ingroup MeshVizXLM_Extract_Isosurf
* 
* @DESCRIPTION Builds the isosurface of the given isovalue in the given dataset.
* 
* When MiVolumeCell::getIsosurfTopology() cannot be defined in polyhedral cells,
* an MiTessellator::getNewTessellatorPolyhedron() is required as an argument of 
* getNewInstance() to produce a volume mesh made up of cells compatible with the 
* marching cube algorithm. 
* @note Only instances from MiTessellator::getNewTessellatorPolyhedron()
* are supported, any other types derived from MiTessellator will be ignored.
* 
*/
class MESHVIZXLM_EXTR_API MiIsosurfExtractUnstructured : virtual public MiBaseExtractor
{
public:
  virtual ~MiIsosurfExtractUnstructured() {}

  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */ 
  static MiIsosurfExtractUnstructured* getNewInstance(const MiVolumeMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator=NULL);

  /**
  * @copydoc MiIsosurfExtractIjk::extractIsovalue()
  */ 
  virtual const MeXSurfaceMeshUnstructured& extractIsovalue(double isovalue, const MiScalardSetI& dataSet, const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * Builds the isosurface of the given isovalue in the given dataset and as 
  * a line mesh representing the edges of each cell. 
  * @note In the case of a dataset bound PER_CELL, it will be converted into 
  * a new internal dataset bound PER_NODE and cached in the extractor.
  * @param isovalue Value for which an isosurface must be computed
  * @param dataSet The input data set used to compute the isovalue from
  * @param cellFilter The cell filter
  * @return The extracted isosurface as line mesh
  */
  virtual const MeXLineMeshUnstructured& extractLineIsovalue(double isovalue, const MiScalardSetI& dataSet, const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * Extracts a scalar set from the volume mesh. The scalars are mapped onto the 
  * current extracted isosurface refering to either the line mesh or the surface mesh depending on
  * whether extractIsovalue() or extractLineIsovalue() was last called.
  *
  * @param inputSet the input scalar set defined on the volume mesh
  * @return the output scalar set defined on the latest extracted mesh
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) = 0;

  /**
  * Extracts a vector set from the volume mesh. The vectors are mapped onto the 
  * current extracted isosurface refering to either the line mesh or the surface mesh depending on
  * whether extractIsovalue() or extractLineIsovalue() was last called.
  *
  * @param inputSet the input vector set defined on the volume mesh
  * @return the output vector set defined on the latest extracted mesh
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;
  
  /**
  * Returns the result of the extraction as a line mesh.
  */
  virtual const MeXLineMeshUnstructured& getLineExtract() const = 0;
};


#endif 


