/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MILOGICALSLICEEXTRACTCURVILINEAR_H
#define  _MILOGICALSLICEEXTRACTCURVILINEAR_H

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/extractors/MiBaseLogicalSliceExtract.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshCurvilinear.h>
#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetIj.h>

class MiCellFilterIjk;
class MiVolumeMeshCurvilinear;
class MiTessellator;

/**
 * @DTEXT Logical slice extractor for a curvilinear volume mesh. 
 * 
 * @ingroup MeshVizXLM_Extract_Logicalslice
 * 
 * @see MiLogicalSliceExtractRegular
 *
 */
class MESHVIZXLM_EXTR_API MiLogicalSliceExtractCurvilinear : virtual public MiBaseExtractor
{
public:
  virtual ~MiLogicalSliceExtractCurvilinear() {} 
  
  /**
  * @copydoc MiInterpolatedLogicalSliceExtract::getNewInstance()
  */ 
  static MiLogicalSliceExtractCurvilinear* getNewInstance(const MiVolumeMeshCurvilinear& mesh, bool parallel = true, MiTessellator* tessellator = NULL);

  /**
  * @copydoc MiLogicalSliceExtractRegular::extractLogicalSlice()
  */
  virtual const MeXSurfaceMeshCurvilinear& extractLogicalSlice(MiMesh::Dimension axis, size_t sliceIndex, bool upperVertex, const MiCellFilterIjk* cellFilter=NULL) = 0;

 /**
  * @copydoc MiLogicalSliceExtractRegular::extractScalarSet().
  */
  virtual const MeXDataSetIj<double>& extractScalarSet(const MiScalardSetIjk& inputSet) = 0;

  /**
  * @copydoc MiLogicalSliceExtractRegular::extractVec3Set().
  */
  virtual const MeXDataSetIj<MbVec3d>& extractVec3Set(const MiVec3dSetIjk& inputSet) = 0;

  /**
  * @copydoc MiLogicalSliceExtractRegular::getExtract().
  */
  virtual const MeXSurfaceMeshCurvilinear& getExtract() const = 0;


};

#endif 


