/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiOutlineExtractIj_H
#define  _MiOutlineExtractIj_H

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshRegular.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshRectilinear.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshCurvilinear.h>
#include <MeshVizXLM/mesh/data/MiDataSetIj.h>
#include <MeshVizXLM/extrmesh/MeXLineMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/tessellator/MiTessellator.h>

class MiCellFilterIj;

/**
 * @DTEXT Outline extractor for a structured surface mesh.
 * 
 * @ingroup MeshVizXLM_Extract_Outline
 * 
 * @DESCRIPTION 
 * Builds an unstructured line mesh containing the outline of the given surface mesh.
 * The outline of a mesh is made up of all the edges that belong to a single cell. 
 * Internal edges of a mesh will not be displayed except when they are
 * adjacent to dead cells.
 * 
 */
class MESHVIZXLM_EXTR_API MiOutlineExtractIj : virtual public MiBaseExtractor
{
public:
  virtual ~MiOutlineExtractIj() {}

  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */
  static MiOutlineExtractIj* getNewInstance(const MiSurfaceMeshRegular& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiOutlineExtractIj* getNewInstance(const MiSurfaceMeshRectilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiOutlineExtractIj* getNewInstance(const MiSurfaceMeshCurvilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);

  /**
  * @copydoc MiOutlineExtractIjk::extractOutline()
  */
  virtual const MeXLineMeshUnstructured& extractOutline(const MiCellFilterIj* cellFilter=NULL) = 0;
  
  /**
  * @copydoc MiCellExtractIj::extractScalarSet()
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetIj& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIj::extractVec3Set()
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetIj& inputSet) = 0;
 
  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXLineMeshUnstructured& getExtract() const = 0;

};

#endif /* _MiOutlineExtractIj_H */


