/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (December 2009)
**=======================================================================*/
#ifndef  _MiPerCellToPerNodeExtractUnstructuredIjk_h
#define  _MiPerCellToPerNodeExtractUnstructuredIjk_h

#include <MeshVizXLM/extractors/MiPerCellToPerNodeExtractHexahedronIjk.h>

/**
 * @DTEXT Convert data sets bound per cell into data sets bound per node on a given structured hexahedron mesh.
 * 
 * @ingroup MeshVizXLM_Extract_Utilities
 * 
 * @DESCRIPTION 
 * This conversion tool is another type of extractor which takes a data set bound per cell on a
 * MiVolumeMeshHexahedronIjk as input and produces a new data set bound per node on the same mesh. 
 *
 * The value computed at a given node is the average of values from cells sharing this node,
 * except dead cells. 
 * 
 * The following example shows how to convert data sets bound per cell:
 * \if_cpp
 * \code
 * MiPerCellToPerNodeExtractUnstructuredIjk* extract =
 *   MiPerCellToPerNodeExtractHexahedronIjk::getNewInstance(mesh);
 * const MeXScalardSetI& perNodeScalarSet = extract->extractScalarSet(perCellScalarSet);
 * const MeXVec3dSetI&   perNodeVectorSet = extract->extractVec3Set(perCellVectorSet);
 * \endcode
 * \endif
 * \if_dotnet
 * \endif
 * \if_java
 * \endif
 *
 */
typedef SoDEPRECATED_TYPEDEF(10000,"Use MiPerCellToPerNodeExtractHexahedronIjk interface instead.") MiPerCellToPerNodeExtractHexahedronIjk MiPerCellToPerNodeExtractUnstructuredIjk;

#endif

