/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiPlaneSliceExtractUnstructured_h
#define  _MiPlaneSliceExtractUnstructured_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>

class MiCellFilterI;
class MiTessellator;
class MeXLineMeshUnstructured;

/**
 * @DTEXT Plane slice extractor for unstructured volume meshes
 * 
 * @ingroup MeshVizXLM_Extract_Slice
 * 
 * @DESCRIPTION A plane slice is the intersection of a given plane with the mesh volume. The extracted plane slice
 * is an unstructured surface.
 * 
 */
class MESHVIZXLM_EXTR_API MiPlaneSliceExtractUnstructured : virtual public MiBaseExtractor
{
public:
  virtual ~MiPlaneSliceExtractUnstructured() {}

  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */ 
  static MiPlaneSliceExtractUnstructured* getNewInstance(const MiVolumeMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator=NULL);

  /**
  * @copydoc MiPlaneSliceExtractIjk::extractSlice()
  */ 
  virtual const MeXSurfaceMeshUnstructured& extractSlice(const MbVec3<double>& normal, double distance, const MiCellFilterI* cellFilter=NULL) = 0;
  
  /**
  * Builds the topology and geometry of a plane slice intersecting the volume mesh 
  * and returns them as a line mesh representing the edges of each cell. 
  * 
  * @return the extracted plane slice as an unstructured line mesh.
  * @param normal Vector normal to the plane slice
  * @param distance Position of the plane relatively to the origin along the normal
  * @param cellFilter The cell filter object. 
  */
  virtual const MeXLineMeshUnstructured& extractLineSlice(const MbVec3<double>& normal, double distance, const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * Extracts a scalar set from the volume mesh. The scalars are mapped onto the 
  * current extracted planeslice refering to either the line mesh or the surface mesh depending on
  * whether extractSlice() or extractLineSlice() was last called.
  *
  * @param inputSet the input scalar set defined on the volume mesh
  * @return the output scalar set defined on the latest extracted mesh
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) = 0;

  /**
  * Extracts a vector set from the volume mesh. The vectors are mapped onto the 
  * current extracted planeslice refering to either the line mesh or the surface mesh depending on
  * whether extractSlice() or extractLineSlice() was last called.
  *
  * @param inputSet the input vector set defined on the volume mesh
  * @return the output vector set defined on the latest extracted mesh
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;

  /**
  * Returns the result of the extraction as a line mesh.
  */
  virtual const MeXLineMeshUnstructured& getLineExtract() const = 0;

};

#endif 


