/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiSkinExtractIjk_H
#define  _MiSkinExtractIjk_H

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/MiVolumeMeshRegular.h>
#include <MeshVizXLM/mesh/MiVolumeMeshRectilinear.h>
#include <MeshVizXLM/mesh/MiVolumeMeshCurvilinear.h>
#include <MeshVizXLM/mesh/MiVolumeMeshVertexHexahedronIjk.h>
#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/tessellator/MiTessellator.h>

class MiCellFilterIjk;

/**
 * @DTEXT Skin extractor for a structured volume mesh.
 * 
 * @ingroup MeshVizXLM_Extract_Skin
 * 
 * @DESCRIPTION Builds an MiSurfaceMeshUnstructured interface containing the mesh skin for the given data set at the given value.
 * The skin of a mesh is made up of all the faces that belong to only one cell. 
 * Internal faces of a mesh will not be displayed unless they are adjacent to dead cells.
 * 
 * @note The skin extraction processing on MiVolumeMeshCurvilinear and MiVolumeMeshVertexHexahedronIjk can be cancelled by setting
 * a MiExtractorCallback, which will throw a MiCancellationException.
 * 
 */
class MESHVIZXLM_EXTR_API MiSkinExtractIjk : virtual public MiBaseExtractor
{
public:
  virtual ~MiSkinExtractIjk() {}

  //@{
  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */
  static MiSkinExtractIjk* getNewInstance(const MiVolumeMeshRegular& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiSkinExtractIjk* getNewInstance(const MiVolumeMeshCurvilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiSkinExtractIjk* getNewInstance(const MiVolumeMeshRectilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiSkinExtractIjk* getNewInstance(const MiVolumeMeshVertexHexahedronIjk& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  //@}

  /**
  * Add a new cell range constraint to iterate over when performing the skin extraction.
  * Default is to iterate over all cells in the mesh.
  * Adding a new range to the extractor changes its state, thus triggering a new extraction
  * when calling extractSkin() even if the mesh remains the same.
  * Note: For now, only the first added cellrange is considered during the extraction. Further added ones
  * are ignored.
  * @param rbegin the smallest cell indices (i,j,k) in the range.
  * @param rend the largest cell indices (i,j,k) in the range (not included in extraction).
  * Note: The value UNDEFINED_ID may be used for any index and is interpreted as the 
  * minimum/maximum cell index available in the current mesh for that axis.
  */
  virtual void addCellRange(MbVec3ui rbegin, MbVec3ui rend) = 0;

  /**
  * Remove all cell ranges previously added.
  * Clearing all ranges changes the extractor state, thus triggering a new extraction when
  * calling extractSkin() even if the mesh remains the same.
  */
  virtual void clearCellRanges() = 0;

  /**
  * Builds the topology and geometry of a mesh skin.
  * Throws a MiCancellationException if cancelled (see MiExtractorCallback).
  * @param cellFilter The cell filter.
  * @return The skin extracted as an unstructured surface mesh.
  */
  virtual const MeXSurfaceMeshUnstructured& extractSkin(const MiCellFilterIjk* cellFilter=NULL) = 0;
  
  /**
  * Extracts a scalar set from the volume mesh. The scalars are mapped onto the 
  * current extracted skin. 
  *
  * @param inputSet the input scalar set defined on the volume mesh
  * @return the output scalar set defined on the resulting surface mesh
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetIjk& inputSet) = 0;

  /**
  * Extracts a vector set from the volume mesh. The vectors are mapped onto the 
  * current extracted skin.
  *
  * @param inputSet the input vec3 set defined on the volume mesh
  * @return the output scalar set defined on the resulting surface mesh
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetIjk& inputSet) = 0;
 
  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;

};

#endif /* _MiSkinExtractIjk_H */


