/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiSurfaceExtractUnstructured_h
#define  _MiSurfaceExtractUnstructured_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

class MiCellFilterI;
class MiSurfaceMeshUnstructured;
class MiTessellator;

/**
 * @DTEXT Surface mesh extractor for unstructured surface mesh.
 * 
 * @ingroup MeshVizXLM_Extract_Surface
 * 
 * @DESCRIPTION Builds an unstructured surface mesh from another unstructured surface mesh by
 *   removing dead cells and filtered cells.
 */
class MESHVIZXLM_EXTR_API MiSurfaceExtractUnstructured : virtual public MiBaseExtractor
{
public:
  virtual ~MiSurfaceExtractUnstructured() {}

  /**
  * Factory method returning a new instance of a class implementing this interface.
  * @param mesh The input mesh
  * @param parallel When true, tries to create an extract module using a parallel algorithm to speed up the extraction.
  * @param tessellator The tessellator object used for tessellating non linear cells (quadratic,...).
  * @note The extraction algorithm does not have a parallel implementation and does not take into account the
  *       the tessellator.
  */
  static MiSurfaceExtractUnstructured* getNewInstance(const MiSurfaceMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator = NULL);

  /**
  * Builds a new linear surface mesh by removing dead cells and filtered cells from the input mesh given to the
  * factory method getNewInstance().
  * @param[in] cellFilter The optional cell filter. surface cells excluded by this filter are removed in the build mesh.
  * @return The surface mesh.
  */  
  virtual const MeXSurfaceMeshUnstructured& extract(const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * Extracts a scalar set from the input surface mesh. The scalars are mapped onto the
  * current extracted surface.
  *
  * @param inputSet the input scalar set defined on the surface mesh
  * @return the output scalar set defined on the latest extracted surface mesh
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) =0;

  /**
  * Extracts a vector set from the input surface mesh. The vectors are mapped onto the
  * current extracted surface.
  *
  * @param inputSet the input vector set defined on the input surface mesh
  * @return the output vector set defined on the latest extracted surface mesh
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * @copydoc MiSkinExtractIjk::getExtract()
  */
  virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;

};

#endif

