/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiTessellatedSurfaceExtract_h
#define  _MiTessellatedSurfaceExtract_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/MeXLineMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

#include <Inventor/STL/vector>

class MiCellFilterI;
class MiSurfaceMeshUnstructured;
class MiTessellator;
class MeXPointMeshCurvilinear;

/**
 * @DTEXT Tessellated surface mesh extractor for unstructured and non linear 2D mesh.
 * 
 * @ingroup MeshVizXLM_Extract_Tessellate
 * 
 * @DESCRIPTION Builds a tessellated linear surface mesh from non linear 2D mesh.
 *   The tessellation is done by using the given MiTessellator (see tessellate()).
 */
class MESHVIZXLM_EXTR_API MiTessellatedSurfaceExtract : virtual public MiBaseExtractor
{
public:
  virtual ~MiTessellatedSurfaceExtract() {}

  /**
  * Factory method returning a new instance of a class implementing this abstract class.
  * @param mesh The input mesh 
  * @param parallel When true, tries to create an extract module using a parallel algorithm to speed up the extraction. 
  * @note Only some of the extraction algorithms have a parallel implementation.
  */ 
  static MiTessellatedSurfaceExtract* getNewInstance(const MiSurfaceMeshUnstructured& mesh, bool parallel = true); 

  /**
  * Builds a new linear surface mesh by tessellating each non linear cell of the input mesh given to the
  * factory method getNewInstance().
  * @param[in] tesselator The instance used to tessellate.
  * @param[in] cellFilter The optional cell filter. surface cells excluded by this filter are neither tessellated nor
  *            included "as is" in the build mesh.
  * @return The tessellated mesh.
  */  
  virtual const MeXSurfaceMeshUnstructured& tessellate(MiTessellator& tesselator, const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * Builds a new linear line mesh by tessellating each non linear cell contour of the input mesh given to the
  * factory method getNewInstance().
  * @param[in] tesselator The instance used to tessellate.
  * @param[in] cellFilter The optional cell filter. surface cells excluded by this filter are neither tessellated nor
  *            included "as is" in the build mesh.
  * @return The tessellated mesh.
  */  
  virtual const MeXLineMeshUnstructured&    tessellateLine(MiTessellator& tesselator, const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * Builds a new point mesh by collecting all cell nodes of the input mesh given to the
  * factory method getNewInstance().
  * @param[in] cellFilter The optional cell filter. surface cells excluded by this filter are not
  *            included "as is" in the build mesh.
  * @return The point mesh.
  */  
  virtual const MeXPointMeshCurvilinear& extractPoints( const MiCellFilterI* cellFilter=NULL) =0;

  /**
  * Extracts a scalar set from the input mesh. For a PER_NODE dataset, the value of each point 
  * of the tessellation is calculated by using the shape functions of the input cell and the parametric 
  * coordinates of the each tessellated point. For a PER_CELL dataset, the value of each tessellated cell 
  * is just a copy of the value of each input cell.
  * The scalars are mapped onto the current tessellated mesh refering to either the surface mesh, the line mesh 
  * or the point mesh depending on whether tessellate(), tessellateLine() or extractPoints() was last called.
  *
  * @param[in] inputSet the input scalar set defined on the input mesh.
  * @return the output scalar set defined on the tessellated mesh. 
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) =0;

  /**
  * Extracts a vector set from the input mesh. For a PER_NODE dataset, the value of each point 
  * of the tessellation is calculated by using the shape functions of the input cell and the parametric 
  * coordinates of the each tessellated point. For a PER_CELL dataset, the value of each tessellated cell 
  * is just a copy of the value of each input cell.
  * The vectors are mapped onto the current tessellated mesh refering to either the surface mesh, line mesh
  * or the point mesh depending on whether tessellate(), tessellateLine() or extractPoints() was last called.
  *
  * @param[in] inputSet the input vector set defined on the input mesh.
  * @return the output vector set defined on the tessellated mesh. 
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

 /**
  * @copydoc MiTessellatedLineExtract::getExtract()
  */
 virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;

 /**
 * Returns the result of the extraction as a line mesh.
 */
 virtual const MeXLineMeshUnstructured& getLineExtract() const = 0;

 /**
 * Returns the result of the extraction as a point mesh.
 */
 virtual const MeXPointMeshCurvilinear& getPointExtract() const = 0;

};

#endif

