/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MxHalfPyramidCell_h
#define _MxHalfPyramidCell_h

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#endif

#include <MeshVizXLM/extractors/MxTetrahedronCellExtract.h>
#include <MeshVizXLM/mesh/cell/MiVolumeCell.h>


/**
* @internal 
* Used only to check if a point is inside a pyramid by splitting the pyramid 
* into 2 tetrahedrons.
*
* NOTE: This class should not be used by applications, and may not exist in future releases.
*/
SoINTERNAL class MESHVIZXLM_EXTR_API MxHalfPyramidCell : virtual public MiVolumeCell
{
public:

  void setNodeIds(size_t nodeId0, size_t nodeId1, size_t nodeId2, size_t nodeId3)
  {
    m_nodeIds[0] = nodeId0;
    m_nodeIds[1] = nodeId1;
    m_nodeIds[2] = nodeId2;
    m_nodeIds[3] = nodeId3;
  }

  virtual size_t getNodeIndex(size_t nod) const { return m_nodeIds[nod]; }

  virtual bool isPointInsideCell(const MiGeometryI& meshGeometry, const MbVec3d &point, std::vector<double>& weights) const 
  {
    return MxTetrahedronCellExtract::isPointInsideCell(meshGeometry,this,point,weights);
  }

  void getWeight(const MiGeometryI& meshGeometry,const MbVec3d& point, std::vector<double>& weights) const 
  {
    return MxTetrahedronCellExtract::getWeight(meshGeometry,this,point,weights);
  }

  virtual size_t getNumFacets() const { return 4; }
  virtual size_t getNumEdges() const { return 6; }
  virtual size_t getNumNodes() const { return 4; }
  virtual size_t appendNodesIndexOfFacet (size_t, std::vector<size_t>&) const { return 0; }
  virtual void getIsosurfTopology(unsigned char, std::vector< std::pair<size_t,size_t> >& ) const {}


protected:
  size_t m_nodeIds[4];
};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif


