/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeXPointMeshCurvilinear_H
#define _MeXPointMeshCurvilinear_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiPointMeshCurvilinear.h>
#include <MeshVizXLM/extrmesh/MeXMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/topology/MeXTopologyI.h>

/** 
* @DTEXT Extracted curvilinear point mesh abstract interface.
* 
* @ingroup MeshVizXLM_ExtractedMesh
* 
* @DESCRIPTION
*    This interface specifies an extracted cloud of points defined by a list of non-connected nodes. 
*    Curvilinear Point meshes do not contain an explicit description for each cell as is 
*    the case for unstructured point meshes.
*
*/
class MeXPointMeshCurvilinear : virtual public MeXMeshUnstructured, public MiPointMeshCurvilinear
{
public:
  /**
  * Returns the topology of this mesh.
  */
  virtual const MeXTopologyI& getTopology() const = 0;

  /**
  * @copydoc MeXSurfaceMeshUnstructured::getNewClone()
  */
  virtual const MeXPointMeshCurvilinear* getNewClone() const = 0;
};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


