/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeXSurfaceMeshRectilinear_H
#define _MeXSurfaceMeshRectilinear_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/extrmesh/MeXMeshIj.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshRectilinear.h>
#include <MeshVizXLM/extrmesh/geometry/MeXSurfaceGeometryRectilinear.h>

/**
* @DTEXT Extracted rectilinear surface mesh abstract interface.
* 
* @ingroup MeshVizXLM_ExtractedMesh
* 
* @DESCRIPTION
*    This interface is similar to MiSurfaceMeshRegular except that the nodes are not equally spaced along each axis.
*    Nodes are defined by a set of NUMI points on I, NUMJ points on J. 
*    Thus each cell is still a parallelogram but its surface depends on the spacing between two consecutive values of I and J.
*    @note The virtual methods are the same as in the parent class. 
*    The RTTI system is used by some extraction algorithms to identify the mesh type in order to implement some specific 
*    optimization based on the properties described above. 
* 
*/
class MeXSurfaceMeshRectilinear : public MiSurfaceMeshRectilinear, virtual public MeXMeshIj
{
public:
  /**
  * Returns the geometry of this mesh. 
  */
  virtual const MeXSurfaceGeometryRectilinear& getGeometry() const = 0;

  /**
  * @copydoc MeXSurfaceMeshUnstructured::getNewClone() const
  */
  virtual const MeXSurfaceMeshRectilinear* getNewClone() const = 0;
};

#endif


