/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeXSurfaceMeshUnstructured_H
#define _MeXSurfaceMeshUnstructured_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiSurfaceMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/MeXMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/topology/MeXSurfaceTopologyExplicitI.h>

/**
* @DTEXT Extracted unstructured surface mesh abstract interface.
* 
* @ingroup MeshVizXLM_ExtractedMesh
* 
* @DESCRIPTION
*    This interface defines an extracted unstructured surface mesh. It can contain any type of 
*    surface cell, like triangle, quadrangle, etc...
* 
*/
class MeXSurfaceMeshUnstructured : public MiSurfaceMeshUnstructured, virtual public MeXMeshUnstructured
{
public:
  /**
  * Returns the topology of this mesh.
  */
  virtual const MeXSurfaceTopologyExplicitI& getTopology() const = 0;

  /**
  * Gets a new clone of this mesh. This method creates and returns a new instance
  * of the class of this object by copying all fields of this instance.
  * The application is responsible for deleting the new instance returned.
  */
  virtual const MeXSurfaceMeshUnstructured* getNewClone() const = 0;

};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


