/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeXVolumeMeshUnstructured_H
#define _MeXVolumeMeshUnstructured_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/MeXMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/topology/MeXVolumeTopologyExplicitI.h>
#include <Inventor/STL/vector>



/**
* @DTEXT Extracted unstructured volume mesh abstract interface.
* 
* @ingroup MeshVizXLM_ExtractedMesh
* 
* @DESCRIPTION
*    This interface defines an extracted unstructured volume mesh. It can contain any type of 
*    volume cell, like tetrahedrons, hexahedrons etc.
* 
*/
class MeXVolumeMeshUnstructured : public MiVolumeMeshUnstructured, virtual public MeXMeshUnstructured
{
public:
  /**
  * Returns the topology of this mesh. 
  */
  virtual const MeXVolumeTopologyExplicitI& getTopology() const = 0;

  /**
  * @copydoc MeXSurfaceMeshUnstructured::getNewClone() const
  */
  virtual const MeXVolumeMeshUnstructured* getNewClone() const = 0;
};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


