/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeXDataSet_H
#define _MeXDataSet_H

#include <MeshVizXLM/mesh/data/MiTypedDataSet.h>

class SoBufferObject;

//-----------------------------------------------------------------------------
/**
* @DTEXT Generic extracted data set interface.
* 
* @ingroup MeshVizXLM_ExtractedMesh_DataSets
* 
* @DESCRIPTION
*    A generic abstract template interface for an extracted data set with boundaries (min and max) returned by any extract of a mesh.
* 
*/
template <typename _T>
class MeXDataSet: virtual public MiTypedDataSet<_T>
{
public:
  /**
  * Returns the minimum value of this set.
  */
  virtual _T getMin() const = 0;

  /**
  * Returns the maximum value of this set.
  */
  virtual _T getMax() const = 0;
  
  /*
  * Returns the mean value of this set.
  */
  virtual _T getMean() const = 0;

  /*
  * Returns the standard deviation value of this set.
  */
  virtual _T getStandardDeviation() const = 0;

  /**
  * Returns the buffer that stores the extracted dataset.
  *
  * @NOTES
  * This buffer is not always available: in that case the method returns null.
  *
  * @return the internal buffer of the extracted data or null if it is not available.
  */
  virtual const SoBufferObject* getBuffer() const = 0;

  /**
  * Gets a new clone of this dataset. This method creates and returns a new instance
  * of the class of this object by copying all fields of this instance.
  * The application is responsible for deleting the new instance returned.
  */
  virtual const MeXDataSet<_T>* getNewClone() const = 0;

};

template <>
class MeXDataSet<std::string> : virtual public MiTypedDataSet<std::string>
{
  /**
  * Gets a new clone of this dataset. This method creates and returns a new instance
  * of the class of this object by copying all fields of this instance.
  * The application is responsible for deleting the new instance returned.
  */
  virtual const MeXDataSet<std::string>* getNewClone() const = 0;
};

template class MESHVIZXLM_EXTR_API MeXDataSet<double>;

/**
* @ingroup MeshVizXLM_ExtractedMesh_DataSets
* Specialization for extracted scalar sets containing double
*/
typedef MeXDataSet<double>  MeXScalardSet;

template class MESHVIZXLM_EXTR_API MeXDataSet<MbVec3d>;

/**
* @ingroup MeshVizXLM_ExtractedMesh_DataSets
* Specialization for extracted vector sets containing MbVec3d
*/
typedef MeXDataSet<MbVec3d> MeXVec3dSet;

/**
* @ingroup MeshVizXLM_ExtractedMesh_DataSets
* Specialization for extracted string sets containing std::string
*/
typedef MeXDataSet<std::string> MeXStringSet;

#endif


