/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeXDataSetI_H
#define _MeXDataSetI_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSet.h>

/**
* @DTEXT Generic data set interface for extracted unstructured meshes.
* 
* @ingroup MeshVizXLM_ExtractedMesh_DataSets
* 
* @DESCRIPTION
*    A generic abstract template interface for data sets returned by any extract of unstructured mesh.
* 
*/
template <typename _T>
class MeXDataSetI : virtual public MiDataSetI<_T>, virtual public MeXDataSet<_T>
{
public:
  /**
  * Returns the number of elements in the data set.
  */
  virtual size_t getSize() const = 0;

  /**
  * Gets a new clone of this dataset. This method creates and returns a new instance
  * of the class of this object by copying all fields of this instance.
  * The application is responsible for deleting the new instance returned.
  */
  virtual const MeXDataSetI<_T>* getNewClone() const = 0;

};

/**
* @ingroup MeshVizXLM_ExtractedMesh_DataSets
* Specialization for extracted unstructured scalar sets containing double
*/
typedef MeXDataSetI<double>  MeXScalardSetI;

/**
* @ingroup MeshVizXLM_ExtractedMesh_DataSets
* Specialization for extracted unstructured vector sets containing MbVec3d
*/
typedef MeXDataSetI<MbVec3d> MeXVec3dSetI;

/**
* @ingroup MeshVizXLM_ExtractedMesh_DataSets
* Specialization for extracted unstructured string sets containing std::string
*/
typedef MeXDataSetI<std::string> MeXStringSetI;

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


