/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeXDataSetIj_H
#define _MeXDataSetIj_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/data/MiDataSetIj.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSet.h>

//-----------------------------------------------------------------------------
/**
* @DTEXT Generic data set interface for extracted structured surface meshes.
* 
* @ingroup MeshVizXLM_ExtractedMesh_DataSets
* 
* @DESCRIPTION
*    A generic abstract template interface for a data set returned by any extract of a structured surface mesh.
* 
*/
template <typename _T>
class MeXDataSetIj : virtual public MiDataSetIj<_T>, virtual public MeXDataSet<_T>
{
public:
  /**
  * Returns the size of the dataset along the first logical axis.
  */
  virtual size_t getSizeI() const = 0;
  /**
  * Returns the size of the dataset along the second logical axis.
  */
  virtual size_t getSizeJ() const = 0;

  /**
  * Gets a new clone of this dataset. This method creates and returns a new instance
  * of the class of this object by copying all fields of this instance.
  * The application is responsible for deleting the new instance returned.
  */
  virtual const MeXDataSetIj<_T>* getNewClone() const = 0;

};

/**
* @ingroup MeshVizXLM_ExtractedMesh_DataSets
* Specialization for extracted structured scalar sets containing double
*/
typedef MeXDataSetIj<double>  MeXScalardSetIj;
/**
* @ingroup MeshVizXLM_ExtractedMesh_DataSets
* Specialization for extracted structured vector sets containing MbVec3d
*/
typedef MeXDataSetIj<MbVec3d> MeXVec3dSetIj;

/**
* @ingroup MeshVizXLM_ExtractedMesh_DataSets
* Specialization for extracted structured string sets containing std::string
*/
typedef MeXDataSetIj<std::string> MeXStringSetIj;

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif

