/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeWGeometryI_h
#define _MeWGeometryI_h

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/extrmesh/geometry/MeXGeometryI.h>
#include <Inventor/STL/vector>

class MiCell;
class MiVolumeCell;

/**
* @DTEXT Abstract interface to write unstructured mesh geometry.
* 
* @ingroup MeshVizXLM_ExtractedMesh_Geometry
* 
* @DESCRIPTION
*    This interface is used by the existing tessellator instances (see MiTessellator)
*    to write into the geometry of the tessellated line, surface and volume meshes.
*    It is designed to allow the application to implement its own tessellator class.
*
*/
class MeWGeometryI : virtual public MeXGeometryI
{
public:

  /** Add a new interpolated node computed by the tessellator and its associated 
  * parametric coordinate to the tessellated geometry. 
  * @param[in] coord  Node coordinate. 
  * @param[in] pcoord Parametric coordinate. 
  */
  virtual void addInterpolatedCoord(const MbVec3d& coord, const MbVec3d& pcoord) = 0;

  /**
  * Add an input node associated with its index in the input geometry.
  * @param[in] coord  Node coordinate. 
  * @param[in] nodeId Node id in the input mesh. 
  */
  virtual void addInputCoord(const MbVec3d& coord, size_t nodeId) = 0;

  /**
  * Add the center of a given cell.
  * @param[in] cell  Given cell. 
  * @param[in] geometry Geometry to used for center computation
  */
  virtual void addCellCenter(const MiCell* cell, const MiGeometryI& geometry) = 0;

  /**
  * Add the center of a facet in the given volume cell.
  * @param[in] cell  Given volume cell. 
  * @param[in] facetId Facet id in the given cell. 
  * @param[in] geometry Geometry used for coordinate computation
  */
  virtual void addFacetCenter(const MiVolumeCell* cell, size_t facetId, const MiGeometryI& geometry) = 0;

};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif

