/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeXGeometryExplicit_H
#define _MeXGeometryExplicit_H

#include <MeshVizXLM/extrmesh/geometry/MeXGeometry.h>

class SoBufferObject;

/**
* @DTEXT Generic geometry interface for extracted meshes with explicit coordinates.
* 
* @ingroup MeshVizXLM_ExtractedMesh_Geometry
* 
* @DESCRIPTION
*    Generic geometry interface.
*    This type of geometry is typically used by extracted mesh interfaces with explicit
*    coordinates computed by the extractors. 
* 
*/
class MeXGeometryExplicit : virtual public MeXGeometry
{
public:
  /**
  * Returns the buffer that stores the geometry of the extracted shape.
  * The content of this buffer is compatible with Open Inventor buffered shapes, thus it can
  * be used by fields such as SoBufferedShape#vertexBuffer.
  * @NOTES
  * This buffer is not always available: In that case the method returns null.
  *
  * @return the internal buffer used to store the geometry of the extracted shape
  * or null if it is not available.
  */
  virtual const SoBufferObject* getBuffer() const = 0;
};


#endif 


