/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Jul 2016)
**=======================================================================*/
#ifndef _MeXTopologyExplicitI_H
#define _MeXTopologyExplicitI_H

#include <MeshVizXLM/extrmesh/topology/MeXTopologyI.h>

class SoBufferObject;

//-----------------------------------------------------------------------------
/**
 * @DTEXT List of extracted cells interface.
 * 
 * @ingroup MeshVizXLM_ExtractedMesh_Topology
 * 
 * @DESCRIPTION
 * A generic abstract interface for an extracted explicit mesh topology. 
 * 
 */
class MeXTopologyExplicitI : virtual public MeXTopologyI
{
public:

  /**
   * Returns the buffer that stores the topology of the extracted shape. 
   * The content of this buffer is compatible with Open Inventor buffered shape, thus it can 
   * be used by dedicated fields as SoBufferedShape#indexBuffer.
   * @NOTES
   * This buffer is not always available: in that case the method returns null.
   *
   * @return the internal buffer used to store the topology of the extracted shape
   * or null if it is not available.
   */
  virtual const SoBufferObject* getBuffer() const = 0;

};


#endif


