/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : M. Bonaventure (Nov 2010)
**=======================================================================*/
#ifndef _MeXTopologyI_H
#define _MeXTopologyI_H

#include <MeshVizXLM/mesh/topology/MiTopologyI.h>

//-----------------------------------------------------------------------------
/**
* @DTEXT List of extracted cells interface.
* 
* @ingroup MeshVizXLM_ExtractedMesh_Topology
* 
* @DESCRIPTION
*    A generic abstract interface for an extracted implicit mesh topology. 
* 
*/
class MeXTopologyI : virtual public MiTopologyI
{
public:

  /**
  * Returns true if the input cell mapping is available.
  * If false, the getInputCellId() methods will return UNDEFINED_ID.
  */
  virtual bool hasInputCellMapping() const = 0;

  //@{
  /**
  * Returns cell indices (I/J/K) of the input cell containing the extracted cell with the given id.
  * This defines a mapping between extracted cells and input cells if the hasInputCellMapping() method
  * returns true, otherwise these methods return UNDEFINED_ID.
  * @param id the index of the cell to check
  *
  * @note  When dealing with a structured mesh as an input, the J/K indices may be UNDEFINED_ID. This is 
  *        a temporary limitation. In that case, the I index is a flat index combining the 3 indices and 
  *        must be unflatten using the input topology dimensions as follow:
  * @verbatim
  size_t numCellsI = inputTopology.getNumCellsI();
  size_t numCellsJ = inputTopology.getNumCellsJ();
  size_t flatId = topology.getInputCellIdI(id);
  size_t inputIdK = flatId / (numCellsI * numCellsJ);
  size_t IJ = flatId % (numCellsI * numCellsJ);
  size_t inputIdJ = IJ / numCellsI;
  size_t inputIdI = IJ % numCellsI;
  @endverbatim
  */ 
  virtual size_t getInputCellIdI( size_t SO_UNUSED_PARAM(id) ) const = 0;
  virtual size_t getInputCellIdJ( size_t SO_UNUSED_PARAM(id) ) const = 0;
  virtual size_t getInputCellIdK( size_t SO_UNUSED_PARAM(id) ) const = 0;
  //@}

};


#endif


