/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (Dec 2010)
**=======================================================================*/


#ifndef _MO_FACEDETAILI_
#define _MO_FACEDETAILI_

#include <MeshVizXLM/mapping/details/MoFaceDetail.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: MoFaceDetailI
//
//  Detail information about vertex-based shapes made of faces. It
//  adds the index of the input cell of unstructured meshes and 
//  structured line meshes 
//
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Stores detail information about vertex-based shapes made of faces from 
 * unstructured meshes and structured line meshes.
 * 
 * @ingroup MeshVizXLM_Mapping_Details
 * 
 * @DESCRIPTION
 *   This class contains detail information about a face in a vertex-based
 *   shape made of faces (extends MoFaceDetail). Additional information includes
 *   the index of the cell that contains this face in the mesh stored in the associated 
 *   MoMeshDetail (see MoFaceDetail::getMeshDetail()).
 *  
 * 
 * @SEE_ALSO
 *    SoDetail,
 *    MoFaceDetail,
 *    MoMeshDetail,
 *    MoSurfaceMeshDetail,
 *    SoPickedPoint,
 *    SoPrimitiveVertex,
 *    SoVertexShape
 * 
 */ 

class MESHVIZXLM_DMAP_API MoFaceDetailI : public MoFaceDetail {

  SO_DETAIL_HEADER(MoFaceDetailI);

 public:
  /**
   * Constructor.
   */
  MoFaceDetailI();
  /**
   * Destructor.
   */
  virtual ~MoFaceDetailI();

  /**
  * Returns the index of the cell containing the face within the input mesh.
  */
  size_t                      getCellIndex() const    { return m_cellIndex; }

  // Returns an instance that is a copy of this instance. The caller
  // is responsible for deleting the copy when done.
  virtual MoFaceDetailI *      copy() const;

 SoEXTENDER public:
  // Copies the given details
  MoFaceDetailI(const MoFaceDetail* faceDetail, const MoMeshDetail* meshDetail);

 SoINTERNAL public:
  static void                 initClass();
  static void                 exitClass();

 private:
  size_t                      m_cellIndex;

};

#endif /* _MO_FACEDETAILI_ */

