/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (Dec 2010)
**=======================================================================*/


#ifndef _MO_LINEDETAILI_
#define _MO_LINEDETAILI_

#include <MeshVizXLM/mapping/details/MoLineDetail.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: MoLineDetailI
//
//  Detail information about vertex-based shapes made of line
//  segments. It adds the index of the input cell of unstructured meshes and 
//  structured line meshes 
//
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Stores detail information about vertex-based shapes made of line segments
 * from unstructured meshes and structured line meshes 
 * 
 * @ingroup MeshVizXLM_Mapping_Details
 * 
 * @DESCRIPTION
 *   This class contains detail information about a line segment in a
 *   vertex-based shape made of line segments (extends MoLineDetail). 
 *   Additional information includes the index of the cell containing the line in the
 *   mesh stored in the associated MoMeshDetail (see MoLineDetail::getMeshDetail()).
 * 
 * @SEE_ALSO
 *    SoDetail,
 *    MoLineDetail,
 *    MoMeshDetail,
 *    MoSurfaceMeshDetail,
 *    SoPickedPoint,
 *    SoPrimitiveVertex,
 *    SoVertexShape
 * 
 */ 

class MESHVIZXLM_DMAP_API MoLineDetailI : public MoLineDetail {

  SO_DETAIL_HEADER(MoLineDetailI);

 public:
  /**
   * Constructor.
   */
  MoLineDetailI();
  /**
   * Destructor.
   */
  virtual ~MoLineDetailI();

  /**
  * Returns the index of the cell containing the face within the input mesh.
  */
  size_t                      getCellIndex() const    { return m_cellIndex; }

  // Returns an instance that is a copy of this instance. The caller
  // is responsible for deleting the copy when done.
  virtual MoLineDetailI *      copy() const;

 SoEXTENDER public:
  // Copies the given details
  MoLineDetailI(const MoLineDetail* lineDetail, const MoMeshDetail* meshDetail);

 SoINTERNAL public:
  static void                 initClass();
  static void                 exitClass();

 private:
  size_t                      m_cellIndex;

};

#endif /* _MO_LINEDETAILI_ */

