/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (Dec 2010)
**=======================================================================*/


#ifndef _MO_LINEMESHDETAIL_
#define _MO_LINEMESHDETAIL_

#include <MeshVizXLM/mapping/details/MoMeshRepresentationDetail.h>

#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

class MeXLineMeshUnstructured;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: MoLineMeshDetail
//
//  Detail information about a mesh representation defined by a line.
//
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Stores detail information about a mesh representation defined by a line.
 * 
 * @ingroup MeshVizXLM_Mapping_Details
 * 
 * @DESCRIPTION
 *   This class contains detail information about a mesh representation defined by a
 *   line. It includes the extracted line. 
 * 
 * @SEE_ALSO
 *    SoDetail,
 *    MoMeshRepresentationDetail
 *    MoLineDetail,
 *    MeXLineMeshUnstructured,
 * 
 */ 

class MESHVIZXLM_DMAP_API MoLineMeshDetail : public MoMeshRepresentationDetail {

 SO_DETAIL_HEADER(MoLineMeshDetail);

 public:
  /**
   * Constructor.
   */
  MoLineMeshDetail();
  /**
   * Destructor.
   */
  virtual ~MoLineMeshDetail();

  /*
  * Returns the extracted line
  */
  const MeXLineMeshUnstructured* getExtractedMesh() const   { return m_extractedMesh; }

  // Returns an instance that is a copy of this instance. The caller
  // is responsible for deleting the copy when done.
  virtual MoLineMeshDetail *  copy() const;

 SoEXTENDER public:
  MoLineMeshDetail(const MeXLineMeshUnstructured* mesh, const std::vector<const MeXScalardSetI*>& scalarsets);

 SoINTERNAL public:
  static void                 initClass();
  static void                 exitClass();

private:
  const MeXLineMeshUnstructured*   m_extractedMesh;

};

#endif /* _MO_LINEMESHDETAIL_ */

