/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (Nov 2010)
**=======================================================================*/


#ifndef _MO_MESHDETAIL_
#define _MO_MESHDETAIL_

#include <Inventor/details/SoSubDetail.h>
#include <Inventor/STL/vector>

#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MeshVizXLM/mesh/data/MiTypedDataSet.h>

class MiMesh;

class MoFaceDetail;
class MoLineDetail;

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

//////////////////////////////////////////////////////////////////////////////
//
//  Class: MoMeshDetail
//
//  Detail information about a mesh.
//
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Stores detail information about a mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Details
 * 
 * @DESCRIPTION
 *   This class contains detail information about a mesh, like the mesh type, the mesh
 *   itself as an MiMesh and the associated color scalarset as an MiBoundedDataSet.
 *
 *   Detail objects are returned by the SoPickedPoint class after picking.
 * 
 * @SEE_ALSO
 *    SoDetail,
 *    SoPickedPoint,
 *    MoFaceDetail,
 *    MoLineDetail,
 *    MiMesh,
 *    MiBoundedDataSet,
 * 
 */ 

class MESHVIZXLM_DMAP_API MoMeshDetail : public SoDetail {

 SO_DETAIL_HEADER(MoMeshDetail);

 public:
  /**
   * Constructor.
   */
  MoMeshDetail();
  /**
   * Destructor.
   */
  virtual ~MoMeshDetail();

  /*
  * Returns the type of the mesh
  */
  MeshType getMeshType() const   { return m_meshType; }

  /*
  * Returns the mesh
  */
  const MiMesh* getMesh() const   { return m_mesh; }

  /*
  * Returns the first associated color scalarset, NULL if none.
  */
  const MiScalardSet* getColorScalarSet() const;

  /*
  * Returns the list of associated color scalarsets, empty if none.
  */
  const std::vector<const MiScalardSet*>& getColorScalarSets() const   { return m_colorScalarsets; }

  // Returns an instance that is a copy of this instance. The caller
  // is responsible for deleting the copy when done.
  virtual MoMeshDetail *  copy() const;

 SoEXTENDER public:
  MoMeshDetail(const MiMesh* mesh, MeshType meshType);

  // set the associated scalarsets
  void setColorScalarSets( const std::vector<const MiScalardSet*>& colorScalarsets );
  // creates a new specialized face detail from the generic given one.
  // returns either a MoFaceDetailI, MoFaceDetailIj or a MoFaceDetailIjk depending on
  // the mesh type stored in this.
  MoFaceDetail* specilizeFaceDetail(const MoFaceDetail* faceDetail) const;
  // creates a new specialized line detail from the generic given one.
  // returns either a MoLineDetailI, MoLineDetailIj or a MoLineDetailIjk depending on
  // the mesh type stored in this.
  MoLineDetail* specilizeLineDetail(const MoLineDetail* lineDetail) const;

 SoINTERNAL public:
  static void                 initClass();
  static void                 exitClass();

  // temporary methods that convert a flat id into I/J/K indices until 
  // the MeXTopologyI is proprely implementated in all extractors for IJK meshes
  void computeIj(size_t id, size_t& i, size_t &j) const ;
  void computeIjk(size_t id, size_t& i, size_t &j, size_t &k) const;

private:

  MeshType                          m_meshType;
  const MiMesh*                     m_mesh;
  std::vector<const MiScalardSet*>  m_colorScalarsets;

};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHDETAIL_ */

