/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
** Modified by : M. Bonaventure (Mar 2010)
**=======================================================================*/
/*==============================================================================
 *   File        : MoCellFilterElement.h
 *   Classes     : MoCellFilterElement
 *   Author(s)   : Pascal Doux
 *   Date        : 6 6 2008
 *==============================================================================
 *
 * Description : Element that stores a cell filter.
 *
 *============================================================================*/

#ifndef  _MO_CELLFILTER_ELEMENT_
#define  _MO_CELLFILTER_ELEMENT_

#include <Inventor/elements/SoReplacedElement.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>

class MiCellFilter;

/**
* @DTEXT Stores the current cell filter.
* 
* @ingroup MeshVizXLM_Mapping_Elements
*
* @DESCRIPTION
*   This element stores the current cell filter.
* @SEE_ALSO
*   MoCellFilter
*/

class MESHVIZXLM_DMAP_API MoCellFilterElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(MoCellFilterElement);
  
 public:
  /** Sets the current cell filter */
  static void set(SoState *state, SoNode *node, CellFilterType cellFilterType, const MiCellFilter *cellFilter);
  
  /** Returns the current cellfilter from the state */
  static const MiCellFilter *getCellFilter(SoState *state, CellFilterType &cellFilterType);

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the geoOrigins match in both elements.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the class
  static void initClass();
  static void exitClass();

 protected:
  const MiCellFilter *m_cellFilter;
  size_t              m_cellFilterTimeStamp;
  CellFilterType      m_cellFilterType;
  
  virtual ~MoCellFilterElement();
  
};
/*----------------------------------------------------------------------------*/

#endif // _MO_CELLFILTER_ELEMENT_


