/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
** Modified by : M. Bonaventure (Mar 2010)
**=======================================================================*/
/*==============================================================================
 *   File        : MoDrawStyleElement.h
 *   Classes     : MoDrawStyleElement
 *   Author(s)   : Pascal Doux
 *   Date        : 8 9 2008
 *==============================================================================
 *
 * Description : Element that stores a data binding.
 *
 *============================================================================*/

#ifndef  _MO_DRAWSTYLE_ELEMENT_
#define  _MO_DRAWSTYLE_ELEMENT_

#include <Inventor/elements/SoReplacedElement.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>

class MoDataBinding;

/**
* @DTEXT Stores the current draw style.
* 
* @ingroup MeshVizXLM_Mapping_Elements
*
* @DESCRIPTION
*   This element stores the current draw style.
* @SEE_ALSO
*   MoDrawStyle
*/
class MESHVIZXLM_DMAP_API MoDrawStyleElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(MoDrawStyleElement);
  
 public:
  
  /** Sets the current draw style */
  static void set(SoState *state, MoDrawStyle *node);

  static void set( SoState* state, SoNode* node, bool displaySolid, bool displayEdges, bool displayPoints, float fadingThreshold );
  
  /** Returns the current DrawStyle from the state */
  static bool getDrawStyle(SoState *state, bool& displaySolid, bool& displayEdges, bool& displayPoints);

  static float getFadingThreshold(SoState *state);

  /** Returns the default Drawstyle from the state */
  static bool getDefault(bool& displaySolid, bool& displayEdges, bool& displayPoints, float& fadingThreshold);

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the geoOrigins match in both elements.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement *copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the class
  static void initClass();
  static void exitClass() ;

 protected:
  bool m_displaySolid;
  bool m_displayEdges;
  bool m_displayPoints;
  float m_fadingThreshold;
  bool m_isSet;
  
  virtual ~MoDrawStyleElement();
  
};
/*----------------------------------------------------------------------------*/

#endif // _MO_DRAWSTYLE_ELEMENT_


