/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
** Modified by : M. Bonaventure (Mar 2010)
**=======================================================================*/
/*==============================================================================
 *   File        : MoMeshElement.h
 *   Classes     : MoMeshElement
 *   Author(s)   : Pascal Doux
 *   Date        : 16 2 2009
 *==============================================================================
 *
 * Description : Element that stores a Tessellator.
 *
 *============================================================================*/

#ifndef  _MoTessellatorElement_
#define  _MoTessellatorElement_

#include <Inventor/elements/SoReplacedElement.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>

class MiTessellator;

/**
* @DTEXT Stores the current tessellator.
* 
* @ingroup MeshVizXLM_Mapping_Elements
*
* @DESCRIPTION
*   This element stores a tesselator in the traversal state list.
* @SEE_ALSO
*   MoTesselator
*/
class MESHVIZXLM_DMAP_API MoTessellatorElement : public SoReplacedElement 
{

  SO_ELEMENT_HEADER(MoTessellatorElement);

public:

  /** Sets the current tessellator */
  static void set(SoState *state, SoNode *node, MiTessellator *tess , size_t nodeTimeStamp);

  /** Returns the current tessellator from the state */
  static MiTessellator *getTessellator(SoState *state, size_t& eltTimeStamp);

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the geoOrigins match in both elements.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

  SoINTERNAL public:
  // Initializes the class
  static void initClass();
  static void exitClass() ;

  /**
  *  Return the timestamp of the associated node
  */
  size_t getTimeStamp() const;

protected:
  MiTessellator *m_tessellator;
  size_t         m_tessTimeStamp;
  size_t         m_nodeTimeStamp;
  
  virtual ~MoTessellatorElement();
  
};
/*----------------------------------------------------------------------------*/

#endif // _MoTessellatorElement_


