/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#pragma once

#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MeshVizXLM/mapping/nodes/MoActionNode.h>
#include <MeshVizXLM/mapping/interfaces/MiColorMapping.h>
#include <Inventor/SbColorRGBA.h>
#include <Inventor/STL/vector>

/**
 * @DTEXT  Property node that defines a combine color mapping.
 * 
 * @ingroup MeshVizXLM_Mapping_Attributes
 * 
 * @DESCRIPTION
 *
 *   This node specifies a combine color mapping function defined by a
 *   custom MiColorMapping object provided by the application.  Specifically an
 *   MiColorMapping object that maps a vector of double values to an SbColorRGBA value.
 *
 *   This node is similar to MoCustomColorMapping except that this node allows combining
 *   @I multiple@i scalar values to produce a single color. The field colorScalarSetId from MoMeshRepresentation
 *   is then ignored and all scalars are retrieved from the MoScalarSet nodes found in the state.
 *   The number of values passed to the MiColorMapping implementation corresponds to the number
*    of MoScalarSet nodes in the state.
 *
 *   @note This node has no fields.  Therefore the node itself can be written
 *   to (and read from) an Inventor file, but the actual combine color mapping is
 *   not written or read back.
 *
 *  @note This node is not supported by MoLegend.
 *
 * @FILE_FORMAT_DEFAULT
 *    MoCombineColorMapping {
 *    @TABLE_FILE_FORMAT
 *    @TABLE_END
 *    }
 *
 * @ACTION_BEHAVIOR
 *   Sets the current color mapping.  See MoCombineColorMappingElement.
 *
 * @SEE_ALSO
 *    MiColorMapping,
 *    MoCustomColorMapping,
 *    MoLevelColorMapping,
 *    MoLinearColorMapping,
 *    MoPredefinedColorMapping
 * 
 *
 * @NODE_SINCE_OIV 9.9
 */
class MESHVIZXLM_DMAP_API MoCombineColorMapping : public MoActionNode
{

  SO_NODE_HEADER(MoCombineColorMapping);
  
 public:

  /**
   * Constructor.  Initially the color mapping is empty and has no effect.
   */
   MoCombineColorMapping();

  /**
   * Sets the color mapping interface. Sets the node as modified by calling touch().
   * When setting a new color map, the MiColorMapping::getTimeStamp() must return a different
   * value than previously to actually take into account the change of color map.
   */
   virtual void setColorMapping(const MiColorMapping<std::vector<double>,SbColorRGBA> *colorMapping);

   /**
   * Gets the color mapping interface.
   */
   virtual const MiColorMapping<std::vector<double>, SbColorRGBA>* getColorMapping();


 /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

  SoEXTENDER public:
    virtual void  doAction(SoAction *action);
  
 protected:
   virtual ~MoCombineColorMapping();

   const MiColorMapping<std::vector<double>, SbColorRGBA>* m_colorMapping;

} ; 


