/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MO_CUSTOMCOLORMAPPING_
#define  _MO_CUSTOMCOLORMAPPING_

#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MeshVizXLM/mapping/nodes/MoColorMapping.h>
#include <MeshVizXLM/mapping/interfaces/MiColorMapping.h>

/**
 * @DTEXT  Property node that defines a custom color mapping.
 * 
 * @ingroup MeshVizXLM_Mapping_Attributes
 * 
 * @DESCRIPTION
 *   This node specifies a custom color mapping function defined by a
 *   custom MiColorMapping object provided by the application.  Specifically an
 *   MiColorMapping object that maps a double value to an SbColorRGBA value.
 *
 *   @note This node has no fields.  Therefore the node itself can be written
 *   to (and read from) an Inventor file, but the actual custom color mapping is
 *   not written or read back.
 *
 * @FILE_FORMAT_DEFAULT
 *    PredefinedColorMapping {
 *    @TABLE_FILE_FORMAT
 *    @TABLE_END
 *    }
 *
 * @ACTION_BEHAVIOR
 *   Sets the current color mapping.  See MoColorMappingElement.
 *
 * @SEE_ALSO
 *    MiColorMapping,
 *    MoCombineColorMapping
 *    MoLevelColorMapping,
 *    MoLinearColorMapping,
 *    MoPredefinedColorMapping
 * 
 */
class MESHVIZXLM_DMAP_API MoCustomColorMapping : public MoColorMapping {

  SO_NODE_HEADER(MoCustomColorMapping) ;
  
 public:

  /**
   * Constructor.  Initially the color mapping is empty and has no effect.
   */
  MoCustomColorMapping() ;

  /**
   * Sets the color mapping interface. Sets the node as modified by calling touch().
   * When setting a new color map, the MiColorMapping::getTimeStamp() must return a different
   * value than previously to actually take into account the change of color map.
   */
   virtual void setColorMapping(const MiColorMapping<double,SbColorRGBA> *colorMapping);

   /**
   * Gets the color mapping interface.
   */
   virtual const MiColorMapping<double,SbColorRGBA>* getColorMapping();


 /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
 protected:
  virtual ~MoCustomColorMapping() ;

} ; 

#endif /* _MO_CUSTOMCOLORMAPPING_  */

