/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MO_DRAWSTYLE_
#define  _MO_DRAWSTYLE_

#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/nodes/SoNode.h>

#include <MeshVizXLM/mapping/nodes/MoActionNode.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
 
/**
 * @DTEXT Property node that defines the draw style of representations.
 * 
 * @ingroup MeshVizXLM_Mapping_Attributes
 * 
 * @DESCRIPTION
 * This node specifies the draw style to be used in subsequent nodes inheriting 
 * from MoMeshRepresentation and defining a surface or a line.
 * - The displayFaces field controls drawing cell faces as solid.
 * - The displayEdges field controls drawing cell edges.
 * - The displayPoints field controls drawing node points.
 * - The fadingThreshold field controls the edges and points fading out when used as additional styles.
 *
 *   @TABLE_0B
 *   @TR No Edge Fading
 *   @TD Edge Fading
 *   @TR @IMAGE edge_fading_off.png
 *   @TD @IMAGE edge_fading_on.png
 *   @TABLE_END
 *
 * See MoMaterial for setting the rendering attributes of facets, edges and points.
 *
 * Use this node, for example, to efficiently render a colored surface and
 * the outlines of its cells using a single rendering node.
 * When the fields #displayFaces and #displayEdges are TRUE, it is possible that a surface
 * (for instance extracted by a MoMeshSkin or a MoMeshSlab) is rendered in 2 passes. The first pass
 * draws the cell faces of the surface, and the second pass draws the cell edges in addition to the faces.
 * The rendering in 2 passes can occur only for very large surface (containing millions of triangles or
 * quadrangles) where the first pass can be done quickly before starting additional computations to display the edges.
 * Note: The rendering of surfaces extracted from an unstructured grid is always done in one pass.
 *
 * @FILE_FORMAT_DEFAULT
 *    DataBinding {
 *    @TABLE_FILE_FORMAT
 *       @TR displayFaces           @TD TRUE
 *       @TR displayEdges           @TD FALSE
 *       @TR displayPoints          @TD FALSE
 *       @TR fadingThreshold        @TD 0
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *  MoMaterial
 *
 * @ACTION_BEHAVIOR
 *  Sets the current draw style. See MoDrawStyleElement.
 * 
 */
class MESHVIZXLM_DMAP_API MoDrawStyle : public MoActionNode {

  SO_NODE_HEADER(MoDrawStyle) ;
  
 public:

  /**
   * Constructor.
   */
  MoDrawStyle() ;

  /** 
  * The display mode for mesh faces.
  * When set to TRUE (default), the surface of mesh representations are filled.
  * Otherwise, they are not filled.
  */
  SoSFBool displayFaces;

  /** 
  * The display mode for mesh edges.
  * When set to TRUE, the edges of faces are displayed. 
  * Otherwise, they are not displayed (Default).
  */
  SoSFBool displayEdges;
   
  /** 
  * The display mode for mesh node points.
  * When set to TRUE, the node points are displayed. 
  * Otherwise, they are not displayed (Default).
  */
  SoSFBool displayPoints;

  /** 
  * Threshold allowing to fade out extra styles of a representation as it gets away from the view point.
  *
  * If fadingThreshold is 0, no fading is done. This is the default behavior. If fadingThreshold > 0, a fading effect may occur on the rendering.
  * In many cases, this field is just interpreted as a boolean value (fading/no fading) for edges rendering. That means that in many cases,
  * the edge fading is done automatically without needing any threshold value, i.e. the floating value of the field is just ignored.
  * However in some cases, we have some limitation that needs to use a threshold value. For those cases,
  * this threshold defines the pixel length limit on screen under which edges start fading out.
  * Setting the threshold to 5 leads to fade out edges with less than 5 pixels on screen.
  *
  * Rendering a surface containing some polygons with more than 8 edges is a typical example where the threshold value is needed.
  *
  * In any case, the floating value of the threshold is used to fade out the points.
  *
  * Note: when the fading is activated, a transparency is required so be sure to check SoGLRenderAction::TransparencyType documentation in order to be aware of known transparency limitations (AA compatibility).
  */
  SoSFFloat fadingThreshold;

 /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
  SoEXTENDER public:
  virtual void  doAction(SoAction *action) ;

protected:
  virtual ~MoDrawStyle() ;

} ; 

#endif /* _MO_DRAWSTYLE_  */

